#include "Target.hpp"

RealXbeeTransmitter xbee_transmitter;

Target::Target(int address_msb, int address_lsb, int target_number)
{
    get_address_for_xbee(address_msb, address_lsb);
    this->target_number = target_number;
}

void Target::rise(int mode, int timeout)
{
    is_risen = true;
    toPc("Rising target %i!", target_number);
    vector<uint8_t> message;
    message.push_back(target_number);
    message.push_back(mode);
    message.push_back((timeout >> 8) & 0xFF);
    message.push_back(timeout && 0xFF);
    xbee_transmitter.transmit(message, addr_table);
}

void Target::get_address_for_xbee(int address_msb, int address_lsb)
{
    addr_table[0] = address_msb >> 24;
    addr_table[1] = (address_msb >> 16) & 0xFF;
    addr_table[2] = (address_msb >> 8) & 0xFF;
    addr_table[3] = (address_msb) & 0xFF;
    addr_table[4] = address_lsb >> 24;
    addr_table[5] = (address_lsb >> 16) & 0xFF;
    addr_table[6] = (address_lsb >> 8) & 0xFF;
    addr_table[7] = (address_lsb) & 0xFF;
}