#pragma once
#include "ports.hpp"
#include "ServerData.hpp"
#include "GameCoordinator.hpp"
#include <vector>

void dispatch_event_from_target(vector<uint8_t> data, int* address)
{
    if (data[1]) {
        gameCoordinator.target_miss();
    } else {
        gameCoordinator.target_hit((data[2] << 8) | data[3]);
    }
}

void dispatch_event_from_server(ServerEvent *event) {
    toPc("Event Name: %s", event->event);
    if (strcmp(event->event, "start_game") == 0)
    {
        gameCoordinator.start_game(&(event->data));
    } 
    else if (strcmp(event->event, "request_report") == 0)
    {
        gameCoordinator.stop_game();
    }
}