#pragma once
#include <vector>
#include "ports.hpp"
#include "RealXbeeTransmitter.hpp"

extern RealXbeeTransmitter xbee_transmitter;

struct Target
{
    int target_number; //0 or 1
    int addr_table[8]; //64 bit addr
    int is_risen = false;

    Target(int address_msb, int address_lsb, int target_number);

    //mode: ally (0) or enemy (1), timeout 16 bits in ms
    void rise(int mode, int timeout);

    void get_address_for_xbee(int address_msb, int address_lsb);
};
