#include <vector>
#include "ports.hpp"
#include "serverEvents.hpp"
#include "Target.hpp"
#include "RealXbeeReceiver.hpp"
#include "BtnHandler.hpp"
#include "GameCoordinator.hpp"
#include "FreeMem.h"
#include "Rfid.hpp"
#include "serverEvents.hpp"

int main()
{
    cls();
    toPc("Coordinator starting...");
    //toPc("Initial Memory: %i", FreeMem());

    //Starting the different threads
    //Websocket
    Thread Twebsocket_message_receiver(websocket_message_receiver, osPriorityLow, 2400);
    Thread Twebsocket_message_sender(websocket_message_sender, osPriorityLow, 1400);

    //Xbee
    RealXbeeReceiver xbeeReceiver;
    xbeeReceiver.start(&dispatch_event_from_target);

    //Btn interupts
    BtnHandler startBtn(p21, "start");
    BtnHandler nextBtn(p22, "navigate", "next");
    BtnHandler previousBtn(p23, "navigate", "previous");

    //Creating the targets with their 64 bits address
    //Bruno/Max Router - Brisé
    // gameCoordinator.targets.push_back(Target(0x0013A200, 0x4086DA0E, 0));
    // gameCoordinator.targets.push_back(Target(0x0013A200, 0x4086DA0E, 1));

    //Routeur antenne
    gameCoordinator.targets.push_back(Target(0x0013A200, 0x408B419E, 0));
    gameCoordinator.targets.push_back(Target(0x0013A200, 0x408B419E, 1)); // moteur brisé

    gameCoordinator.targets.push_back(Target(0x0013A200, 0x4033198C, 0));
    gameCoordinator.targets.push_back(Target(0x0013A200, 0x4033198C, 1));

    gameCoordinator.on_game_finish = &websocket_message_send;

    Rfid rfid(p5, p6, p7, p28, p27);

    //  while(1) {
    //      //Memory monitoring
    //     toPc("Thread Twebsocket_message_receiver max stack: %i / %i", Twebsocket_message_receiver.max_stack(), Twebsocket_message_receiver.stack_size());
    //     toPc("Thread Twebsocket_message_sender max stack: %i / %i", Twebsocket_message_sender.max_stack(), Twebsocket_message_sender.stack_size());
    //     toPc("Thread gameCoordinator.Tget_next_round max stack: %i / %i", gameCoordinator.Tget_next_round.max_stack(), gameCoordinator.Tget_next_round.stack_size());
    //     toPc("Thread xbeeReceiver.message_handler_thread max stack: %i / %i", xbeeReceiver.message_handler_thread.max_stack(), xbeeReceiver.message_handler_thread.stack_size());
    //     toPc("Thread xbeeReceiver.message_reader_thread max stack: %i / %i", xbeeReceiver.message_reader_thread.max_stack(), xbeeReceiver.message_reader_thread.stack_size());
    //     toPc("Thread rfid.rfid_thread max stack: %i / %i", rfid.rfid_thread.max_stack(), rfid.rfid_thread.stack_size());
    //     Thread::wait(20000);
    // }
    Thread::wait(osWaitForever);
}

