#pragma once
#include "ports.hpp"
#include "Json.h"
#include "ServerData.hpp"

bool get_value_from_json(char *jsonSource, const char *keyName, char *outValue)
{
    Json json(jsonSource, strlen(jsonSource), 40); //Can add 3rd argument if json is too big, default: 32 tokens
    if (!json.isValidJson())
    {
        toPc("Invalid JSON: %s", jsonSource);
        return false;
    }
    if (json.type(0) != JSMN_OBJECT)
    {
        toPc("Invalid JSON.  ROOT element is not Object: %s", jsonSource);
        return false;
    }
    int keyIndex = json.findKeyIndexIn(keyName, 0);
    if (keyIndex == -1)
    {
        //toPc("\"%s\" key not found in json: %s", keyName, jsonSource);
        return false;
    }
    int valueIndex = json.findChildIndexOf(keyIndex, -1);
    if (valueIndex > 0)
    {
        const char *valueStart = json.tokenAddress(valueIndex);
        int valueLength = json.tokenLength(valueIndex);
        strncpy(outValue, valueStart, valueLength);
        outValue[valueLength] = 0;
        return true;
    }
    return false;
}

void parse_server_event_from_json(char *jsonSource, ServerEvent *returnEvent)
{
    char data[250]; //container for the json in "data"
    get_value_from_json(jsonSource, "event", returnEvent->event);

    bool data_parse_successful = get_value_from_json(jsonSource, "data", data);
    if (data_parse_successful)
    {
        char tmp[32];
        if (get_value_from_json(data, "game_id", tmp))
            returnEvent->data.game_id = atoi(tmp);

        if (get_value_from_json(data, "max_reflex_time", tmp))
            returnEvent->data.max_reflex_time = atoi(tmp);

        if (get_value_from_json(data, "number_of_target", tmp))
            returnEvent->data.number_of_target = atoi(tmp);
    }
}