#include "ports.hpp"
#include "MFRC522.h"
#include "serverEvents.hpp"

class Rfid 
{
    public:
        Thread rfid_thread;

        Rfid(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset) : RfChip(mosi, miso, sclk, cs, reset)
        {
            RfChip.PCD_Init();
            rfid_thread = Thread(osPriorityNormal, 850);
            rfid_thread.start(this, &Rfid::read_rfid);
        }

        void read_rfid()
        {
            ServerEvent event;
            strcpy(event.event, "gun");
            while(1)
            {
                if (RfChip.PICC_IsNewCardPresent() && RfChip.PICC_ReadCardSerial())
                {                   
                    for (uint8_t i = 0; i < RfChip.uid.size; i++)
                    {
                        itoa(RfChip.uid.uidByte[i], &(event.data.rfid_code[i]), 16);
                    }
                    event.data.rfid_code[RfChip.uid.size] = '\0';
                    //toPc("RFID received, sending event name: %s, size: %i", event.event, RfChip.uid.size);
                    websocket_message_send(event);
                }
                Thread::wait(500);
            }
        }

    private:
        MFRC522 RfChip;
        
};