#pragma once
#include <vector>
#include "ports.hpp"
#include "Target.hpp"
#include "ServerData.hpp"
#include "GameMode.hpp"
#include "ReflexMode.hpp"
#include "SpeedMode.hpp"

class GameCoordinator
{
    public:
        GameCoordinator();

        void start_game(ServerData *configs);
        void stop_game();
        void ticker_callback();
        void get_next_round();
        void target_hit(int time_taken);
        void target_miss();

        void (*on_game_finish)(ServerEvent) = NULL;

        vector<Target> targets;
        Thread Tget_next_round;
    private:
        vector<GameMode*> game_modes; 
        GameMode* current_game;
        uint16_t target_timeout = 10000;
        uint8_t number_of_targets = 10;
        Ticker ticker;
        Timer timer;
};

extern GameCoordinator gameCoordinator;