#pragma once
#include "ports.hpp"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "jsonParser.hpp"
#include "dispatcher.hpp"

#define USING_DHCP_SERVER 0

EthernetInterface eth;
Websocket ws("ws://1.0.0.1:8080/");
Mail<ServerEvent, 30> messages_to_server;
void websocket_message_send(ServerEvent event);

void ethernet_initialization() {
    #if USING_DHCP_SERVER
        eth.init();
    #else
        char ip_addr[]="1.0.0.2";
        char mask[]="255.255.255.0";
        char gateway[]="1.0.0.1";
        eth.init(ip_addr, mask, gateway); 
    #endif
    
    eth.connect();
    toPc("IP Address is %s", eth.getIPAddress());
    toPc("Mask is %s", eth.getNetworkMask());
}

void websocket_initialization() {
    toPc("Connecting to websocket url: \"ws://1.0.0.1:8080/\"");
    ws.connect();
    if (ws.is_connected()) {
        ws.send("{\"event\":\"mbed\",\"data\":{\"state\": \"connected\"}}");
    }
}

//Thread
void websocket_message_receiver() {
    ethernet_initialization();
    websocket_initialization();

    char msgBuffer[500];
    ServerEvent newEvent;
    while(1) {
        if (!ws.is_connected()) {
            toPc("Disconnected from websocket... Attempting to reconnect");
            websocket_initialization();
        } else {
            if (ws.read(msgBuffer)) {
                toPc("New message received from server");
                parse_server_event_from_json(msgBuffer, &newEvent);
                dispatch_event_from_server(&newEvent);
            }
        }
        Thread::wait(100);
    }
}

//Via thread
void websocket_message_send(ServerEvent event)
{
    ServerEvent *newEvent = messages_to_server.alloc();
    *newEvent = event;
    messages_to_server.put(newEvent);
}

//Direct send
void send_message_to_websocket(ServerEvent *event)
{
    char msgBuffer[500];
    if (strcmp(event->event, "start") == 0) {
        sprintf(msgBuffer, "{"
            "\"event\":\"%s\""
        "}", event->event);
    } else if (strcmp(event->event, "navigate") == 0) {
        sprintf(msgBuffer, "{"
            "\"event\":\"%s\","
            "\"data\":{"
                "\"direction\":\"%s\""
            "}"
        "}", event->event, event->data.direction);
    } else if (strcmp(event->event, "gun") == 0) {
        sprintf(msgBuffer, "{"
            "\"event\":\"%s\","
            "\"data\":{"
                "\"rfid_code\":\"%s\""
            "}"
        "}", event->event, event->data.rfid_code);
    } else { //event == report
        sprintf(msgBuffer, "{"
            "\"event\":\"%s\","
            "\"data\":{"
                "\"targets\": %i,"
                "\"averageReflexTime\": %i,"
                "\"gameLength\": %i,"
                "\"score\": %i"
            "}"
        "}", event->event, event->data.targets, event->data.averageReflexTime, 
        event->data.gameLength, event->data.score);
    }

    //toPc("Sending msg to websocket: %s", msgBuffer);
    ws.send(msgBuffer);
}

//Thread
void websocket_message_sender()
{
    while(1) {
        osEvent evt = messages_to_server.get();
        if (evt.status == osEventMail) {
            ServerEvent *mail = (ServerEvent*)evt.value.p;
            send_message_to_websocket(mail);            
            messages_to_server.free(mail);
        }
        Thread::yield();
    }
}