#pragma once
#include <vector>
#include "ports.hpp"
#include "Target.hpp"
#include "ServerData.hpp"

class GameMode
{
public:
  GameMode(vector<Target> *_targets)
  {
    targets = _targets;
  }

  virtual ServerData GetStats()
  {
    return stats;
  }

  virtual Target* GetNextTarget() = 0;  
  virtual void OnTargetHit(int timeTaken) = 0;
  virtual void OnTargetMiss() = 0;  
  virtual int getTimeBetweenTargets()
  {
    return 1000; //default to 1 sec
  }

  void reset()
  {
    stats.targets = 0;
    stats.score = 0;
    stats.averageReflexTime = 0;
    stats.gameLength = 0;
  }

protected:
  ServerData stats;
  vector<Target>* targets;
  Target *GetRandomTarget()
  {
    int target_nb = rand() % targets->size();
    return &(targets->at(target_nb));

  }
};