#pragma once
#include "ports.hpp"
#include "PinDetect.h"
#include "ServerData.hpp"
#include "serverEvents.hpp"

class BtnHandler {
    PinDetect _interrupt;
    ServerEvent event;
    public:
        BtnHandler(PinName pin, const char *eventName) : _interrupt(pin) {
            strcpy(event.event, eventName);
            _interrupt.mode( PullDown );
            _interrupt.setSampleFrequency();
            _interrupt.attach_asserted(this, &BtnHandler::sendEvent);
        }
        BtnHandler(PinName pin, const char *eventName, const char *direction) : BtnHandler(pin, eventName) {
            strcpy(event.data.direction, direction);
        }
        void sendEvent()
        {
            websocket_message_send(event);
        }
};