/**
@file WSRequest.hpp

@brief Allow communication with a server using a specific websocket.

@poject NerfUS, Team P5
*/
#ifndef ETHERNET_MAGJACK
#define ETHERNET_MAGJACK

#include "WSRequestInterface.hpp"
#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

#define WS_BUFFER_SIZE 32

class WSRequest : public WSRequestInterface
{
    public:
		/**
		* Initialize the communication interface
		*
		* @param url The url to the websocket server (eg. "ws://192.168.137.1:8000/")
		*/
		WSRequest(char *url);

		// From the interface
		virtual int send(char *buffer);
		virtual bool onMessage(char *buffer);
		~WSRequest();
        
    private:
		EthernetInterface eth;
		Websocket ws;
};

#endif