/**
@file WSRequest.cpp

@brief Allow communication with a server using a specific websocket.

@poject NerfUS, Team P5
*/
#include "WSRequest.hpp"


WSRequest::WSRequest(char *url) : ws(url)
{
	eth.init(); //Use DHCP
	eth.connect();
	printf("IP Address is %s\n\r", eth.getIPAddress());

	ws.connect();
}

int WSRequest::send(char *buffer)
{
	return ws.send(buffer);
}

bool WSRequest::onMessage(char *buffer)
{
	while (!ws.read(buffer))
	{
		wait(0.1);
	}
	return true;
}

WSRequest::~WSRequest()
{
	ws.close();
	eth.disconnect();
}