/**
@file WSRequestInterface.hpp

@brief Allow communication with a server using a specific websocket.

@poject NerfUS, Team P5
*/
class WSRequestInterface
{
	/**
	* Allow to send a buffer of information to the server
	*
	* @param buffer The data to send
	* @returns the number of bytes sent
	*/
	virtual int send(char *buffer) = 0;

	/**
	* Blocking method to get message back from the server
	*
	* @param buffer Must be a pointer to the buffer to write the message
	* @return true if a websocket frame has been read
	*/
	virtual bool onMessage(char *buffer) = 0;
};
