#include "mbed.h"
 
InterruptIn pin22(p22);
DigitalOut led1(LED1);

DigitalOut dash(p19);
DigitalOut dot(p20);

Timer interruptTimer;
Timer spaceCountTimer;

bool isInterruptTimerRunning = 1;

Serial pc(USBTX, USBRX);//tx, rx

void classify(int elapsedTime) {
        if(elapsedTime >= 30 && elapsedTime < 200) {
                pc.printf("Dot\t");
                dot = 0;
                wait(0.05);
                dot = 1;
                
        } else if(elapsedTime < 400 && elapsedTime >= 200) {
            pc.printf("Dash\t");
            dash = 0;
            wait(0.05);
            dash = 1;
        }
            
}

void checkForSpace(int elapsedTime) {
    if(elapsedTime > 400) {
        pc.printf("Space\t");    
        spaceCountTimer.reset();
    }    
    
}

void riseLed1() {
//    int elapsedTime = spaceCountTimer.read_ms();
//    checkForSpace(elapsedTime);
    spaceCountTimer.reset();
    if(isInterruptTimerRunning) {
        interruptTimer.start();
    } else {
        interruptTimer.reset();    
    }
    led1 = 1;
}

void fallLed1() {
    int elapsedTime = interruptTimer.read_ms(); 
//    interruptTimer.stop();
    classify(elapsedTime);
    isInterruptTimerRunning = 0;
    spaceCountTimer.reset();
    led1 = 0;
}

int main() {
    
    spaceCountTimer.start();
    pc.baud(9600);
    
    dot = 1;
    dash = 1;
    
    int elapsedTime;
    
    pin22.rise(&riseLed1);  // attach the address of the flip function to the rising edge
    pin22.fall(&fallLed1);
    while(1) {           // wait around, interrupts will interrupt this!
//        wait(0.1);
        elapsedTime = spaceCountTimer.read_ms();
        checkForSpace(elapsedTime);
    }
    
    
}