#include "mbed.h"
DigitalOut UltrasonTriger(p18);
DigitalIn UltrasonEcho(p17);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX,460800);
Serial blueth(p9, p10,115200); // tx,rx,baudrate

void Imp_Ultra(void);
int Rec_Ultra();

int main() {
    
    
    while(1) 
    {
        Imp_Ultra();           
    }
}

void Imp_Ultra(void)
{
    static Timer timer;
    float ultrason_distance;
    //blueth.printf("fonct\n");
    
    
    static short etat = 0;
    
    switch(etat)
    {
        case 0:
            led1 = 1;
            UltrasonTriger = 1; // envoie une impulsion de 10us
            timer.start();
            etat = 1;
            break;
        case 1:
            
            if(timer.read_us() > 10) // fin de l'impulsion
            {
                led1 = 0;
                UltrasonTriger = 0;
                timer.reset();
                etat = 2;   
            }
            break; 
        case 2:
            
            if(UltrasonEcho.read()==1)  // Si on a une reception
            {
                timer.start(); // lance timer pour mersurer l'impulsion
                etat = 3;
            }
            if(timer.read_ms()>30) etat = 4;  // Si au bout de 30ms pas de reception alors aucune mesure
            break;
        case 3:
            
            if(UltrasonEcho.read()==0)  // Mesurer le temps d'impulsion de la reception
            {
                ultrason_distance=timer.read_us()/58-8; // Calcul de la distance
                blueth.printf("La dustance est de %3.2f cm\n",ultrason_distance);
                timer.stop();
                timer.reset();
                etat = 5;
            }
            if(timer.read_ms()>30) etat = 4;
            break;
        case 4:
            blueth.printf("erreur"); // Si pas de recption
            timer.stop();
            timer.reset();
            etat = 5;
            break;
        case 5:
            break;
            
        
    }
}
