#include "mbed.h"
#include "math.h"
#include "bluetoothV2bibli.h"

Serial pc(USBTX, USBRX,460800);
Serial blueth(p9, p10,115200); // tx,rx,baudrate


static int blueRxBuffer[6];         // Buffer de réception de la liaison serie bluetooth
static int blueTxBuffer[6]={240,0,0,0,0,15};             // Buffer de transmission de la liaison serie bluetooth
static int RxBuffer[4][6];                               // Copie de blueRxbuffer à l'issue de la reception des 4 trames
static int paramRx[4][2];                                //0 KP   1 KI   2 KD   3 SPEED
static short flagR=0;


/********************************** Initialisation *************************************/

void init_blueth(void)
{
    blueth.attach(&receptionBlu, Serial::RxIrq);    //Creation interruption de reception
    blueth.printf("Hello world");                   //message de test
}


/******************************* Fonctions de transmission *****************************/

void transmitBlu(void)
{
    static short i = 0;
    if(blueth.writable())                      //fonctionne si la liaison est libre
    {
       blueth.putc(blueTxBuffer[i]);           //transmission de la trame de 6 octets dans le buffer
       i++;
    }
    if(i>5)
    {
        i=0;
        blueth.attach(NULL, Serial::TxIrq);    // on coupe la liaison (ISR de transmssion) tant que pas necessaire pour permettre la reception
    }
}

void formatTrameT(short reg, int val)          // Creation de la trame au format Start Registre Donnees Donnees Donnees Stop
{   
    blueTxBuffer[1]=reg;
    blueTxBuffer[2]=((val&0xFF0000)>>16);         //Conversion sur trois octets independants de la donnee
    blueTxBuffer[3]=((val&0x00FF00)>>8);
    blueTxBuffer[4]=((val&0x0000FF));

    blueth.attach(&transmitBlu, Serial::TxIrq);  //Ouverture de la liaison (ISR de transmission)
}


/****************************** Fonctions de reception ******************************/

void receptionBlu(void)
{
    static short j = 0, compteur=0;
    
    if(blueth.readable())                           //Si la liaison est libre 
    {
        blueRxBuffer[j]=blueth.getc();              //reception
        j++;                                        //Permet d'ecrire les 6 octets dans blueRxBuffer    
        if(j>5)
        {
            j=0;
            for(short i=0;i<6;i++)RxBuffer[compteur][i]=blueRxBuffer[i]; //Si une trame est reçue, on la copie dans RxBuffer
            compteur++;
            if(compteur>4)                          //Permet de savoir si les 4 donnees KP KI KD et SPEED ont été transmises                            
            {
                compteur=0;
                flagR=1;                           //Permet la gestion de decomposition de trames
            }
        }
    }   
}

int get_val_pc(short reg)                          //Permet de connaitre la donnee associée à un registre
{
    short indice;
    if(flagR==1)                                   // Decompose les trames si reception de 4 nouvelles trames
    {
        decomp_trame();                     
        flagR=0;
    }
    if(reg == 30)indice = 0;                    
    if(reg == 45)indice = 1;
    if(reg == 60)indice = 2;
    if(reg == 75)indice = 3;
    return paramRx[indice][1];                    //renvoie la valeur stocke pour un registre 
}

void decomp_trame(void)
{
    for(short i=0;i<4;i++)
    {
        if(RxBuffer[i][0]== 240 && RxBuffer[i][5]==15) //verification des bits start et stop
        {
            paramRx[i][0]= RxBuffer[i][1];             //ecriture du registre
            paramRx[i][1] = RxBuffer[i][2]*pow((double)2,(double)16)+RxBuffer[i][3]*pow((double)2,(double)8)+RxBuffer[i][4];
            //recomposition de la donnee stockee sur 3 octets
        }
    }
}