#include "mbed.h"
#include "bluetoothV1bibli.h"

Serial pc(USBTX, USBRX,460800);
Serial blueth(p9, p10,115200);                      // tx,rx,baudrate

static int blueRxBuffer[20];                               // Buffer de reception de la liaison serie bluetooth
static int blueTxBuffer[6];                                // Buffer de transmission de la liaison série bluetooth

 

void init_blueth(void)
{
    blueth.attach(&receptionBlu, Serial::RxIrq);    //Creation interruption de reception
    blueth.printf("Hello world");                   //message de test
}
    
void send_data (int data)                           //création de la trame avec le start, le registre, les donnees et le stop
{
   
    static int i=0;
    static int bufferTx[6];                         
    bufferTx[i]=data+i;                              //on remplit le buffer à chaque appel de la fonction
    i++;
    if(i>5)
    {
        for(int j=0;j<6;j++)blueTxBuffer[j]=bufferTx[j];  //On copie le buffer quand il est plein dans le buffer de transmission
        blueth.attach(&transmitBlu, Serial::TxIrq);     //Ouverture de la liaison serie 
        i=0;
    }                    
}


void transmitBlu(void)
{
    static int i = 0;
    if(blueth.writable())                           //fonctionne si la liaison est libre
    {
       blueth.putc(blueTxBuffer[i]);                //transmission de la trame de 6 octets
       i++;
    }
    if(i>5)
    {
        i=0;
        blueth.attach(NULL, Serial::TxIrq);         //fermeture de la liaison serie
    }
}

void receptionBlu(void)                             //reception
{                                                   //Manque la décomposition de trame
    static int i = 0;
    if(blueth.readable())
    {
        blueRxBuffer[i]=blueth.getc();             //On remplit le buffer de reception
        i++;
        if(i>5)i=0;
    }   
}
