#ifndef NXPCAM_H
#define NXPCAM_H

#include "PIXY2.h"
#include "Vector.h"

#define SCREEN_CENTER 39 // resolution : 79 - 52
#define INFO_NON_EXPLOITABLE 404

#define COEFF_VIRAGE 80 // + il est élevé + on tourne dans les virages

class NXPCam
{
public:
    NXPCam();
    
    /// STRATEGIE 1 ///
    void init();
    /* Fonction qui renvoie une valeur entre -100 et 100 (à peu près)
     * correspondant à l'écart de trajectoire entre la piste et
     * le milieu de l'écran de la Pixy.
     * La valeur est positive lorsque la voiture est trop à droite
     * et négative lorsqu'elle est trop à gauche */
    int getDeviationTrajectoire();
    int getNormeVecteurs();

    // Fonctions outils
    int getXinutile(int x0, int x1, int x2);
    int getXinutile(int x0, int x1, int x2, int x0past, int x1past);
    
    /// STRATEGIE 2 ///
    Point getPointDir(Vector& v1, Vector& v2);
    
    int xG,xD; 
    
    void affVectors() const;
    void affDiffs() const;
    
private:
    PIXY2 pixy;
    Vector v1, v2, v3;
    Vector v1past, v2past;
};

#endif // NXPCAM_H