#ifndef BT_H
#define BT_H

#include "mbed.h"
#include "math.h"

#define STARTBYTE 240                                                          // Valeur de l'octet de start
#define STOPBYTE  15                                                           // Valeur de l'octet de stop

#define KPBYTE    30                                                           // entete de KP
#define KIBYTE    45                                                           // entete de KI
#define KDBYTE    60                                                           // entete de KD
#define SPCMDBYTE 75                                                           // entete de la commande de vitesse
#define CAMXBYTE  100                                                          // entete de la camera
#define POSBYTE   130                                                          // entete pour la position du robot sur la piste
#define LMBYTE    150                                                          // entete du graphe du moteur gauche
#define RMBYTE    165                                                          // entete du graphe du moteur droit
#define ERRORBYTE 180                                                          // entete du graphe de l'erreur d'asservissement
#define CERRBYTE  195                                                          // entete du graphe de la correction de l'erreur (asservissement)
#define SGRABYTE  210                                                          // entete du graphe de la vitesse du robot

class IHM_Bluetooth
{
public:
    IHM_Bluetooth();
    void run(void);
    
private:
/**************************************** FONCTIONS **************************************/

    void transmitBlu (void);                                                   // Fonction permettant la transmission d'une trame de 6octets (interruption)
   
   
    void receptionBlu (void);                                                  // Fonction d'interruption de reception. 
    
   
    void formatTrameT(short reg, int val);                                     // Creation de trames de 6 octets pour des  donnees a valeur decimale
   
   
    int get_val_pc(short reg);                                                 // Permet de recuperer la valeur associee au entete en entrée 
//                                                                                et stockee dans un tableau apres sa reception  
                                                                               
    void TrameCAM(int CAM1, int CAM2);                                         // Creation d'une trame de 6 octets permettant d'envoyer la position sur X
//                                                                                des vecteurs gauche et droit vu par la camera
    
    void TramePos(int left, int barc, int right);                              // Creation d'une trame de 6 octets permettant d'envoyer la position du robot
//                                                                                sur la piste (cote gauche, barycentre, cote droit)
                                                                               
    void automate_Tx(void);                                                    // Automate pour la transmission. Permet de choisir la trame a creer.
    
/*************************************** VARIABLES ****************************************/

    unsigned int blueRxBuffer[6];                                              // Buffer de reception de la liaison serie bluetooth
    unsigned char blueTxBuffer[6];                                             // Buffer de transmission de la liaison série bluetooth
    unsigned int paramRx[4];                                                   // 0 KP   1 KI   2 KD   3 SPEED
    short cb_lm;                                                               // Checkbox du graphe moteur gauche
    short cb_rm;                                                               // Checkbox du graphe moteur droit
    short cb_err;                                                              // Checkbox du graphe d'erreur de l'asservissement 
    short cb_cerr;                                                             // Checkbox du graphe de la correction de l'erreur (asservissement)
    short cb_speed;                                                            // Checkbox du graphe de la vitesse du robot
    Ticker timer;                                                              // Ticker pour gérer la frequence d'appel de l'automate fonction

};

#endif // BT_H
