#ifndef VOITURE_H
#define VOITURE_H

#include "NXPCam.h"
#include "IHM_Bluetooth.h"

#define ROUES_DROITES 0.075f
#define MAX_DROITE 0.1f
#define MAX_GAUCHE 0.05f
#define PAS 0.001f

#define PERIODE_PWM 20000 // 20 ms

class Voiture
{
public:
    Voiture();
    void run();
    void init();
    void gestionDeplacement(); // gere ligne droite et virage classique
    void tourne(int val); // val comprise entre -100 (gauche) et 100 (droite)
    
private:
    NXPCam cam; // Pixy qui gère le traitement d'images
    
    void gestionRoues(); // fct qui tourne en continu et qui permet de faire tourner progressivement les roues vers 'futureOrientation'
    
    /// GESTION PWM ///
    DigitalOut Pwm_servo; // Correspond au servo-moteur qui oriente les roues avant
    float rapportCycliqueServo;
    float futureOrientation; // variable expliquée dans 'gestionRoues'
    Timer timerRotation; // timer qui permet de faire tourner progressivement
    Timeout timeout; // creer la PWM en + des fonctions en-dessous
    void Pwm_Up(void) {
        Pwm_servo = 1;
        timeout.attach_us(this, &Voiture::Pwm_Down, this->rapportCycliqueServo * PERIODE_PWM);
    }
    void Pwm_Down(void) {
        Pwm_servo = 0;
        timeout.attach_us(this, &Voiture::Pwm_Up, (1 - this->rapportCycliqueServo) * PERIODE_PWM);
    }
    
    PwmOut* motG;
    PwmOut* motD;
    DigitalIn OnOff;
    
    // IHM Bluetooth
    IHM_Bluetooth IHM_bt;
    
    // Debug
    BusOut leds;
};

#endif // VOITURE_H