#include "Voiture.h"

extern Serial bt;
extern Serial pc;

Voiture::Voiture() : Pwm_servo(p22), futureOrientation(ROUES_DROITES), OnOff(p19), leds(LED1, LED2, LED3, LED4)
{
    
}

void Voiture::run()
{
    typedef enum {INIT, DEPLACEMENT} type_etat;
    static type_etat etat = INIT;
    
    switch(etat)
    {
    case INIT:
        this->init();
        etat = DEPLACEMENT;
        break;
        
    case DEPLACEMENT:
        this->gestionDeplacement();
        break;
    }
}

void Voiture::init()
{
    this->motG = new PwmOut(p23);
    this->motD = new PwmOut(p25);
    this->motG->period_us(200);
    this->motD->period_us(200);
    this->timerRotation.start();
    this->timeout.attach_us(this, &Voiture::Pwm_Up, 1); // on lance la pwm du servo
    this->rapportCycliqueServo = this->futureOrientation;
    
    // Pour la config des moteurs //
    DigitalOut dirG(p24);
    DigitalOut dirD(p26);
    DigitalOut ssmG(p11);
    DigitalOut ssmD(p12);
    dirG = 0;
    dirD = 0;
    ssmG = 1;
    ssmD = 1;
    
    // Permet d'attendre qu'on ait bien 2 vecteurs corrects
    cam.init();
    
    IHM_bt.run();
}

void Voiture::gestionDeplacement()
{        
    int dev = this->cam.getDeviationTrajectoire();
    
    if(dev != INFO_NON_EXPLOITABLE)
    {
        bt.printf("tourne vers : %d\n\r", -dev);
        this->tourne(-dev);
    }
        
    this->gestionRoues();
}

void Voiture::tourne(int val)
{
    if(val < -100) val = -100;
    else if (val > 100) val = 100;
    
    val += 100;
    val /= 2;                                    // On transforme le -100 - 100 en pourcentage
    float valf = val;
    valf *= (MAX_DROITE - MAX_GAUCHE) / 100;     // On met le pourcentage dans la plage de la PWM du servomoteur
    valf += MAX_GAUCHE;                          // valmin = MAX_GAUCHE
    
    if(valf >= MAX_GAUCHE && valf <= MAX_DROITE) // pour éviter tout "braquage" dû à une erreur
        this->futureOrientation = valf;
}

void Voiture::gestionRoues()
{    
    if(this->timerRotation.read_ms() > 20)
    {
        if(this->futureOrientation > this->rapportCycliqueServo)
            this->rapportCycliqueServo += PAS;
        else if(this->futureOrientation < this->rapportCycliqueServo)
            this->rapportCycliqueServo -= PAS;
        this->timerRotation.reset();
    }
    
    if(OnOff)
    {
        if(this->futureOrientation < 0.055 || this->futureOrientation > 0.095)
        {
            this->motG->write(0.29f);
            this->motD->write(0.29f);
        }
        else
        {
            this->motG->write(0.28f);
            this->motD->write(0.28f);
        }
    }
    else
    {
        this->motG->write(0);
        this->motD->write(0);
    }
    
    this->motG->write(0);
    this->motD->write(0);
}
