#include "bibli.h"

int getDistance()
{
    static DigitalOut UltrasonTriger(p18);
    static DigitalIn UltrasonEcho(p17);
    
    static Timer timer;
    float ultrason_distance=-1;
    
    static short etat = 0;
    
    switch(etat)
    {
        case 0:
            UltrasonTriger = 1; // envoie une impulsion de 10us
            timer.start();
            etat = 1;
            break;
            
        case 1:
            if(timer.read_us() > 10) // fin de l'impulsion
            {
                UltrasonTriger = 0;
                timer.reset();
                etat = 2;   
            }
            break;
             
        case 2:
            if(UltrasonEcho.read()==1)  // Si on a une reception
            {
                timer.start(); // lance timer pour mersurer l'impulsion
                etat = 3;
            }
            if(timer.read_ms()>30) etat = 4;  // Si au bout de 30ms pas de reception alors aucune mesure
            break;
            
        case 3:
            if(UltrasonEcho.read()==0)  // Mesurer le temps d'impulsion de la reception
            {
                ultrason_distance=timer.read_us()/58-8; // Calcul de la distance
                timer.stop();
                timer.reset();
                etat = 0;
            }
            if(timer.read_ms()>30) etat = 4;
            break;
            
        case 4:
            timer.stop();
            timer.reset();
            etat = 0;
            break;
    }
    return ultrason_distance;
}