#ifndef __CIRCULAR_BUFFER_H__
#define __CIRCULAR_BUFFER_H__

#include "EmbeddedTypes.h"
#include "MemManager.h"

#ifndef gCircularBufferSize_c
#define gCircularBufferSize_c 32
#endif

typedef enum bufferStatus_tag
{
    buffer_Ok_c = 0,
    buffer_Empty_c,
    buffer_Full_c
}bufferStatus_t;

class CircularBuffer {
  public:
    CircularBuffer();
    CircularBuffer(uint32_t sz);
    ~CircularBuffer();
    bufferStatus_t addToBuffer (uint8_t c);
    bufferStatus_t getFromBuffer (uint8_t *c);
    uint32_t getCount();
  private:
    uint8_t *buffer;
    uint32_t size;
    uint32_t readIndex;
    uint32_t writeIndex; 
    uint32_t count;
};

#endif