#include "mbed.h"
#include "ChainableLED.h"

#define NUM_LED 3

// ChainableLED(clk, data, number_of_leds)
ChainableLED color_led(D2, D3, NUM_LED);

int main()
{
    uint8_t index = 0;
    while(1) {
        // generate random RGB values for LED's
        uint8_t R = rand();
        uint8_t G = rand();
        uint8_t B = rand();
        // print message to terminal
        printf("index = %d, R=%x,G=%x,B=%x,",index,R,G,B);

        // ChainableLED.setColorRGB(index_of_led, red, green, blue)
        color_led.setColorRGB(index++, R, G, B);    // increase brightness cascade down chain of LED's
        index = ((index+1) % NUM_LED);              // cycle through LED's
        wait(0.05);
    }
}

