#include "mbed.h"
#include "FXOS8700Q.h"
#include "M2XStreamClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"


#ifndef MAX
#define max(a,b) ({ __typeof__ (a) _a = (a); __typeof__ (b) _b = (b); _a > _b ? _a : _b; })
#endif

#ifndef MIN
#define min(a,b) ({ __typeof__ (a) _a = (a); __typeof__ (b) _b = (b); _a < _b ? _a : _b; })
#endif

char deviceId[] = "<deviceId>"; // Device you want to push to
char streamName[] = "<streamName>"; // Stream you want to push to
char m2xKey[] = "<m2xKey>"; // Your M2X API Key or Master API Key

/*
*  ESP8266 Wifi Config, connect it to D0 on Seeed Grove shield
*/
ESP8266Interface wifi(D1,D0,D3,"wifi SSID","wifi PASSWORD",115200); // TX,RX,Reset,SSID,Password,Baud 

int main()
{
    printf("Starting...\r\n");

    // connect to wifi
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    printf("IP Address is %s \n\r", wifi.getIPAddress());

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey,1,"52.22.150.98");
    int ret;

    // Create an accelerometer instance
    FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
    acc.enable();
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", acc.whoAmI());

    while (true) {

        float x, y, z;
        acc.getX(&x);
        acc.getY(&y);
        acc.getZ(&z);

        printf("Accel X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);

        // Send data to stream
        
            ret = m2xClient.updateStreamValue(deviceId, streamName, x);
            ret = m2xClient.updateStreamValue(deviceId, streamName, y);
            ret = m2xClient.updateStreamValue(deviceId, streamName, z);
            printf("send() returned %d\r\n", ret);
            wait(1.0);
        
    }
}