*-------------------------------------------------------------------------------------*/
/*  Candy Dispenser Demo Code (KL25Z + MPC17510)                                      */
/*------------------------------------------------------------------------------------*/

/*--COMPANY-----AUTHOR------DATE------------REVISION----NOTES-------------------------*/
/*  FSL         B45220      2015.05.15      rev 1.0     initial                       */
/*                                                                                    */
/*--SEQUENCE--------------------------------------------------------------------------*/
/*  -> initializes                                                                    */
/*  -> waits for motion trigger                                                       */
/*  -> dispenses candy at trigger                                                     */
/*------------------------------------------------------------------------------------*/

/*--SPI-------------------------------------------------------------------------------*/
/*  SPI0_CLK    (CLK)   =   PTD1    (J2/12)                                           */
/*  SPI0_MOSI   (MOSI)  =   PTD2    (J2/8)                                            */
/*  SPI0_MISO   (MISO)  =   PTD3    (J2/10)                                           */
/*------------------------------------------------------------------------------------*/

/*--GPIO------------------------------------------------------------------------------*/
/*  SPI0_CS     (CS)    =   PTC2    (J2/6)                                            */
/*  DATA0       (EN)    =   PTC12   (J2/1)                                            */
/*  CTRL1       (IN5)   =   PTA1    (J1/2)                                            */
/*  SPI1_CS     (IN6)   =   PTA2    (J1/4)                                            */
/*------------------------------------------------------------------------------------*/

/*--NOTES-----------------------------------------------------------------------------*/
/*  WORKS WITH USB CABLE FOR FRDM POWER, sensor attached to button power              */
/*------------------------------------------------------------------------------------*/


/*--INCLUDES--------------------------------------------------------------------------*/
#include "mbed.h"

/*--INITS-----------------------------------------------------------------------------*/
//KL25Z + MPC17510 I/O
DigitalOut ENABLE(PTC7);
DigitalOut OUT1(PTD4);
DigitalOut OUT2(PTA12);
DigitalIn SNS(PTC6);
DigitalIn BUTTON_ON(PTB11);

//LED
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);

/*--CONSTANTS-------------------------------------------------------------------------*/

/*--VARIABLES-------------------------------------------------------------------------*/

/*--FUNCTIONS-------------------------------------------------------------------------*/



/**************************************************************************************/
/***MAIN*******************************************************************************/
/**************************************************************************************/
int main()
{
    led_red = 0;
    led_green = 0;
    led_blue = 0;    
    
    while(1)
    {
        wait(1);
        
        while(!BUTTON_ON)
        {
            led_red = 1;
            led_green = 1;
            led_blue = 0;   //set blue LED during init phase (main power on)
        }
        
        wait(1);
        
        while(SNS)
        {
            led_red = 0;  //set red LED when no sense
            led_green = 1;
            led_blue = 1;
        }

        led_red = 1;
        led_green = 0;  //set green LED when sense
        led_blue = 1;
        
        ENABLE = 1;
        OUT1 = 1;   //motor off
        OUT2 = 0;   //motor off
        
        wait_ms(250);
        
        OUT1 = 0;   //motor off
        OUT2 = 0;   //motor off
        ENABLE = 0;
    }
}