#include <math.h>

#include "mbed.h"
#include "USBMouse.h"

USBMouse mouse(ABS_MOUSE);

void move_y(int32_t x_pos, int32_t& y_pos, uint32_t repetition, bool direction)
{
    for (uint32_t i = 0; i < repetition; i++) {
        mouse.press(MOUSE_LEFT);
        if (direction) {
            y_pos++;
        } else {
            y_pos--;
        }
        mouse.move(x_pos, y_pos);
    }
}

void move_x(int32_t& x_pos, int32_t y_pos, uint32_t repetition, bool direction)
{
    for (uint32_t i = 0; i < repetition; i++) {
        mouse.press(MOUSE_LEFT);
        if (direction) {
            x_pos++;
        } else {
            x_pos--;
        }
        mouse.move(x_pos, y_pos);
    }
}

int main(void) {
    int x_center = (X_MAX_ABS - X_MIN_ABS)/2;
    int y_center = (Y_MAX_ABS - Y_MIN_ABS)/2;
    /* these variables store the actual position */
    int32_t new_x = x_center;
    int32_t new_y = y_center;

    /* draw a base for the house*/
    move_y(new_x, new_y, 1200, true);
    move_x(new_x, new_y, 1200, true);
    move_y(new_x, new_y, 1200, false);
    move_x(new_x, new_y, 1200, false);

    /* draw the roof */
    for (uint32_t i=0; i<600; i++)
    {
        mouse.press(MOUSE_LEFT);
        new_y--;
        new_x++;
        mouse.move(new_x, new_y);
    }

    for (uint32_t i=0; i<600; i++)
    {
        mouse.press(MOUSE_LEFT);
        new_y++;
        new_x++;
        mouse.move(new_x, new_y);
    }
}
