#include "mbed.h"

DigitalOut led_red(LED_RED);
InterruptIn sw2(SW2);
Ticker ticker;
float interval;

void led_toggle(void)
{
    led_red = !led_red;
}

void sw2_release(void)
{
    printf("On-board button SW2 was released.\n");
}

void sw2_press(void)
{
    printf("On-board button SW2 was pressed.\n");
    interval -= 0.1f;
    ticker.detach();
    ticker.attach(&led_toggle, interval);
    printf("LED toogle interval was set to: %f \n", interval);
    if (interval < 0.5f) {
        interval = 1.1f;
    }
}

int main()
{
    interval = 1.0f;
    sw2.rise(&sw2_release);
    sw2.fall(&sw2_press);
    ticker.attach(&led_toggle, interval);
    while (true) {
    }
}
