#include "Camera.h"

Camera::Camera(PinName digOut, PinName clock, PinName AnIn ): OUT(digOut), CLK(clock)
{
    IN = new AnalogIn(AnIn);
}

/* 
    Captures a line and fills an array with its values
 */
void Camera::capture()
{
    DigitalOut out(OUT);
    DigitalOut clk(CLK);
    
    out = 1;    //out high
    wait_us(3);
    clk = 1;    //clock high  
    wait_us(3);
    out = 0;    //out low
    wait_us(3);
    clk = 0;    //clock low
    wait_us(3);
    for(int i = 0; i < 128; i++) 
    {        
        clk = 1;     
        wait_us(1);
        clk = 0;
        wait_us(1);
    }
    
    wait_ms(10);
    out = 1;
    wait_us(3);
    clk = 1;
    wait_us(3);
    out = 0;
    wait_us(3);
    clk = 0;
    wait_us(3);
    
    for(int i=0; i<128; i++)
    {              
        imageData[i] = IN->read()*100;  //reads scales the values to be used as an integer percentage of whiteness
        clk = 1;
        wait_us(2);
        clk = 0;  
        wait_us(2);
    }
    return;
}

int Camera::getAverageValue(){
    int sum = 0;
    for(int i = 0; i < 128; i++){
        sum+= imageData[i];
    }
    return sum / 128;
}