#include "mbed.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
DigitalOut  led(D13);                   //link leg
InterruptIn button(PC_13);              //same as "button(USER_BUTTON)"
Serial      pc(D1, D0);                 //Serial reg
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
Ticker  TT;                             //call a timer
int     count;                          //numbers of pressed
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO();                         //initialize IO state
void init_TIMER();                      //set TT_main{} rate
void TT_main();                         //timebase function rated by TT

void pressed();                         //program run when pointed to here
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
int main()
{
    init_IO();                          //initialized value and IRQ(Interrupt request)
    init_TIMER();                       //start TT_main
    pc.baud(9600);                      //set baud rate

    while(1) {                          //main() loop
    }

}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO(void)                      //initialize
{
    led = 0;
    count = 0;
    button.fall(&pressed);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_TIMER()                       //set TT_main{} rate
{
    TT.attach_us(&TT_main, 500000);     //rate set to 0.5 sec
}

void TT_main()                          //interrupt function by TT
{
    led = !led;                         //just to make sure program runnung
    //print out data
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~IRQ funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void pressed()                          //do these shit when triger
{
    //these will be run if pressed() executed
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of IRQ funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//