#include "mbed.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
DigitalOut  led(D13);                   //link leg
DigitalOut  TT_main_ext(D12);           //linl leg
AnalogIn    adc(A0);                    //analog leg
Serial      pc(D1, D0);                 //Serial reg
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
Ticker  TT;                             //call a timer
int     count = 0;                      //one second counter for extrenal led blink
float   adc_read = 0;
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO();                         //initialize IO state
void init_TIMER();                      //set TT_main{} rate
void TT_main();                         //timebase function rated by TT
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
int main()
{
    init_IO();                          //initialized value
    init_TIMER();                       //start TT_main
    pc.baud(9600);                      //set baud rate

    while(1) {                          //main() loop
    }

}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO(void)                      //initialize
{
    led = 0;
    TT_main_ext = 0;
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_TIMER()                       //set TT_main{} rate
{
    TT.attach_us(&TT_main, 1000);
}

void TT_main()                          //interrupt function by TT
{
    TT_main_ext = !TT_main_ext;         //indicate TT_main() function working
    count = count+1;                    //one second counter
    if(count == 1000) {                 //check if main working
        count=0;
        led = !led;
    }
    adc_read = adc.read();
    pc.printf("%.2f\r", adc_read);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//