#include "mbed.h"
#define pi 3.141592f
#define d2r 0.01745329f

//~~~~~~~~~~~~~~~~~~~~~~~~~~~GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
AnalogIn    adc =   A0;                     //analog reading
Serial      pc(D1, D0);                     //Serial reg
PwmOut      led =   D13;                    //link leg
AnalogOut   dac =   A2;                     //Note!!! Only for F446re, not aviable for MCU without DAC
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
Ticker  TT1;                                //call a timer
int     TimeCount = 0;                      //work as a clock
float   SignalGenValue = 0.0f;              //value for DAC or PWM reference
float   SignalProbeValue = 0.0f;            //value for ADC readed
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO();                         //initialize IO state
void init_TIMER();                      //set TT_main{} rate
void TT1_main();                        //timebase function rated by TT1
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
int main()
{
    init_IO();                          //initialized value
    init_TIMER();                       //initialized Timer Inturrupt rate

    while(1) {                          //main() loop
    }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO(void)                      //initialize
{
    led = 0.0f;
    dac = 0.0f;
    pc.baud(115200);                    //set baud rate
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//



//~~~~~~~~~~~~~~~~~~~~~~~~~~~Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_TIMER()                       //set TTx_main{} rate
{
    TT1.attach_us(&TT1_main, 20000);    //0.02 sec
}

void TT1_main()                         //interrupt function by TT1
{
    //generator time reference
    TimeCount = TimeCount + 1;
    if(TimeCount > 50) {
        TimeCount=0;
    }
    
    //start generating signal output
    SignalGenValue = pow(sin(pi*TimeCount/50.0f),2);
    dac = SignalGenValue;               //Note!!! Only for F446re, not aviable for MCU without DAC
    led = SignalGenValue;               //only for you to see directly from eyes
    
    //start reading analog signal 
    SignalProbeValue = adc.read();      //acquire analog data
    
    //print out data
    pc.printf("%.2f\r", SignalProbeValue);  //transfer data to PC
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//