#include "mbed.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
DigitalOut  led =           D13;            //link leg
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
Ticker  TT1;                                //call a timer
Ticker  TT2;                                //call a timer
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO();                         //initialize IO state
void init_TIMER();                      //set TT_main{} rate
void TT1_main();                        //timebase function rated by TT1
void TT2_main();                        //timebase function rated by TT2
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
int main()
{
    init_IO();                          //initialized value
    init_TIMER();                       //initialized Timer Inturrupt rate

    while(1) {                          //main() loop
    }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO(void)                      //initialize
{
    led = 1;
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//



//~~~~~~~~~~~~~~~~~~~~~~~~~~~Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_TIMER()                       //set TTx_main{} rate
{
    TT1.attach_us(&TT1_main, 1000);
    TT2.attach_us(&TT2_main, 1001);
}

void TT1_main()                         //interrupt function by TT1
{
    led = !led;
}

void TT2_main()                         //interrupt function by TT2
{
    led = !led;
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//