#include "mbed.h"

//****************************************************************************** Define
//The number will be compiled as type "double" in default
//Add a "f" after the number can make it compiled as type "float"
#define Ts 0.01f    //period of timer1 (s)
#define Servo_Period 20
//****************************************************************************** End of Define

//****************************************************************************** I/O
//PWM
PwmOut servo(A0);
//Timer Setting
Ticker timer;
//****************************************************************************** End of I/O

//****************************************************************************** Functions
void init_timer(void);
void init_PWM(void);
void timer_interrupt(void);
//****************************************************************************** End of Functions

//****************************************************************************** Variables
// Servo
float servo_duty = 0.066; // 0.025~0.115(-90~+90)(not linear, so the experiment is needed)
//****************************************************************************** End of Variables

//****************************************************************************** Main
int main()
{
    init_timer();
    init_PWM();
    while(1)
    {
    }
}
//****************************************************************************** End of Main

//****************************************************************************** timer_interrupt
void timer_interrupt()
{
    // Code for servo motor    
}
//****************************************************************************** End of timer_interrupt

//****************************************************************************** init_timer
void init_timer()
{
     timer.attach_us(&timer_interrupt, 10000);//10ms interrupt period (100 Hz)
}
//****************************************************************************** End of init_timer

//****************************************************************************** init_PWM
void init_PWM()
{
    servo.period_ms(Servo_Period);
    servo.write(servo_duty);
}
//****************************************************************************** End of init_PWM