// Lcd resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "C12832_lcd.h"
#include "lcd.h"

#define LCD_RES_ID    "lcd"

extern Serial pc;
static C12832_LCD lcd;
// Data from PUT request
static char received_cmd[20];
static char player_in_selection[5];

/* Only PUT method allowed */
static uint8_t lcd_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    memcpy(received_cmd, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
    received_cmd[received_coap_ptr->payload_len] = '\0';
    sprintf(player_in_selection, "%s", received_cmd);
    
    lcd.cls();
    lcd.locate(0,0);
    
    if (!strcmp(player_in_selection, "1")) {
        lcd.printf("You are player 1\nYour paddle is on the left\nGood luck and have fun!");
    }
    else if (!strcmp(player_in_selection, "2")) {
        lcd.printf("You are player 2\nYour paddle is on the right\nGood luck and have fun!");
    }
    else if(!strcmp(player_in_selection, "info")) {
        lcd.printf("You have been registered\nPress joystick to start!");
    }
    
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
    sn_nsdl_send_coap_message(address, coap_res_ptr);
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_lcd_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LCD_RES_ID)-1, (uint8_t*)LCD_RES_ID, 0, 0, 0, &lcd_resource_cb, SN_GRS_PUT_ALLOWED);
    return 0;
}