// Joystick resource implementation

#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"
#include "joystick.h"
#define JOY_RES_ID     "joy"

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
static uint8_t old_joy_val = 0;
static uint8_t joy_val = 0;
static int old_fire_val = 0;
static int fire_val = 0;
static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;
static char joy_msg[10];
extern Serial pc;

/* Thread for calling libNsdl exec function (cleanup, resendings etc..) */
/* Node detects joystick state changes and then sends data. Notification sending is done here. */
static void exec_call_thread(void const *args)
{
    int32_t time = 0;
    while (true)
    {
        // Only if joystick state has changed
        joy_val = joy.read();
        fire_val = fire.read();
        if (fire_val != old_fire_val) {
            time++;
            sn_nsdl_exec(time);
            if(obs_token_ptr != NULL)
            {
                obs_number++;
                if (fire_val == 1) {
                    sprintf(joy_msg, "fire on");
                }
                else if (fire_val == 0) {
                    sprintf(joy_msg, "fire off");
                }
                if (sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, (uint8_t*)joy_msg, strlen(joy_msg), &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0) {
                    pc.printf("Joystick data sending failed!\r\n");
                }
            }
            old_fire_val = fire_val;
        }
        if (joy_val != old_joy_val) {
            time++;
            sn_nsdl_exec(time);
            if(obs_token_ptr != NULL)
            {
                obs_number++;
                if (joy_val == 0x08) {
                    sprintf(joy_msg, "down");
                }
                else if (joy_val == 0x04) {
                    sprintf(joy_msg, "up");
                }
                else if (joy_val == 0x02) {
                    sprintf(joy_msg, "left");
                }
                else if (joy_val == 0x01) {
                    sprintf(joy_msg, "right");
                }
                else if (joy_val == 0x00) {
                    sprintf(joy_msg, "release");
                }
                if (sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, (uint8_t*)joy_msg, strlen(joy_msg), &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0) {
                     pc.printf("Joystick data sending failed!\r\n");
                }
            }
            old_joy_val = joy_val;
        }
    }
}

// Only GET allowed
static uint8_t joy_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    old_joy_val = joy.read();
    old_fire_val = fire.read();
    sn_coap_hdr_s *coap_res_ptr = 0;
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

    coap_res_ptr->payload_len = 10;
    coap_res_ptr->payload_ptr = (uint8_t*)joy_msg;
    
    if(received_coap_ptr->token_ptr)
    {
        if(obs_token_ptr)
        {
            free(obs_token_ptr);
            obs_token_ptr = 0;
        }
        obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
        if(obs_token_ptr)
        {
            memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            obs_token_len = received_coap_ptr->token_len;
        }
    }

    if(received_coap_ptr->options_list_ptr->observe)
    {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
        coap_res_ptr->options_list_ptr->observe_len = 1;
        obs_number++;
    }

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    coap_res_ptr->options_list_ptr->observe_ptr = 0;
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_joystick_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    static Thread exec_thread(exec_call_thread);
    nsdl_create_dynamic_resource(resource_ptr, sizeof(JOY_RES_ID)-1, (uint8_t*)JOY_RES_ID, 0, 0, 1, &joy_resource_cb, SN_GRS_GET_ALLOWED);    
    return 0;
}