// Buzzer resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "buzzer.h"
#include "Beep.h"

#define BUZZ_RES_ID    "buzz"

extern Serial pc;
static Beep buzzer(p26);

// Data from PUT request
static char received_cmd[20];
static char cmd[10];

/* Only PUT method allowed */
static uint8_t buzz_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    memcpy(received_cmd, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
    received_cmd[received_coap_ptr->payload_len] = '\0';
    sprintf(cmd, "%s", received_cmd);
        
    if (!strcmp(cmd, "beep")) {
        buzzer.beep(300,0);
        wait(0.05);
        buzzer.nobeep();
    }
    else if (!strcmp(cmd, "score")) {
        buzzer.beep(400,0);
        wait(0.2);
        buzzer.nobeep();
        buzzer.beep(600,0);
        wait(0.3);
        buzzer.nobeep();
    }
    else if (!strcmp(cmd, "win")) {
        buzzer.beep(700,0);
        wait(0.2);
        buzzer.nobeep();
        buzzer.beep(700,0);
        wait(0.3);
        buzzer.nobeep();
    }
    
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
    sn_nsdl_send_coap_message(address, coap_res_ptr);
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    memset(cmd, 0, 10);
    return 0;
}

int create_buzz_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(BUZZ_RES_ID)-1, (uint8_t*)BUZZ_RES_ID, 0, 0, 0, &buzz_resource_cb, SN_GRS_PUT_ALLOWED);
    return 0;
}