// Led resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "led.h"

#define LED_RES_ID    "led"

extern Serial pc;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

PwmOut rled(p23);
PwmOut gled(p24);
PwmOut bled(p25);

// Data from PUT request
static char received_cmd[20];
static char cmd[10];

/* Only PUT method allowed */
static uint8_t led_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    memcpy(received_cmd, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
    received_cmd[received_coap_ptr->payload_len] = '\0';
    sprintf(cmd, "%s", received_cmd);
    
    if (!strcmp(cmd, "reset")) {
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
    }
    
    else if (!strcmp(cmd, "score")) {
        
        if(led4){
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
        }
        else if(led3){
            led4 = 1;
        }
        else if(led2){
            led3 = 1;
        }
        else if(led1){
            led2 = 1;
        }
        else{
            led1 = 1;
        }
        
        rled.period(0.001);
        for(float i = 0.0; i < 1.0 ; i += 0.01) {
            float p = 3 * i;
            rled = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            gled = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            bled = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            wait(0.005);
        }
    }
    
    else if (!strcmp(cmd, "paddle")) {
        rled = 0;
        gled = 0;
        bled = 0;
        wait(0.1);
    }
    
    else if (!strcmp(cmd, "win")) {
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
        wait(0.25);
        led1 = 1;
        led2 = 1;
        led3 = 1;
        led4 = 1;
        wait(0.25);
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
        wait(0.25);
        led1 = 1;
        led2 = 1;
        led3 = 1;
        led4 = 1;
        wait(0.25);
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
    }
    
    rled = 1;
    gled = 1;
    bled = 1;
    
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
    sn_nsdl_send_coap_message(address, coap_res_ptr);
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    memset(cmd, 0, 10);
    return 0;
}

int create_led_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    rled = 1;
    gled = 1;
    bled = 1;
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LED_RES_ID)-1, (uint8_t*)LED_RES_ID, 0, 0, 0, &led_resource_cb, SN_GRS_PUT_ALLOWED);
    return 0;
}