// Accelerometer resource implementation

#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"
#include "accelerometer.h"
#include "MMA7660.h"
#define ACC_RES_ID     "acc"
#define X_AXIS "x"
#define Y_AXIS "y"
#define Z_AXIS "z"
 
static MMA7660 MMA(p28, p27);
static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;
//static char acc_val[8];
static char acc_val[20];
// Data from PUT request
static char received_cmd[20];
static char selected_axis[20];
extern Serial pc;

/* Thread for calling libNsdl exec function (cleanup, resendings etc..) */
static void exec_call_thread(void const *args)
{
    int32_t time = 0;
    strcpy(selected_axis, "xy");
    MMA.setSampleRate(120);
    while (true)
    {
        time++;
        sn_nsdl_exec(time);
        if(obs_token_ptr != NULL)
        {
            obs_number++;
            if (!strcmp(selected_axis, X_AXIS Y_AXIS Z_AXIS)) {
                sprintf(acc_val,"%2.2f;%2.2f;%2.2f", MMA.x(), MMA.y(), MMA.z());
            }
            else if (!strcmp(selected_axis, X_AXIS Y_AXIS)) {
                sprintf(acc_val,"%2.2f;%2.2f", MMA.x(), MMA.y());
            }
            else if (!strcmp(selected_axis, X_AXIS Z_AXIS)) {
                sprintf(acc_val,"%2.2f;%2.2f", MMA.x(), MMA.z());
            }
            else if (!strcmp(selected_axis, Y_AXIS Z_AXIS)) {
                sprintf(acc_val,"%2.2f;%2.2f", MMA.y(), MMA.z());
            }
            else if (!strcmp(selected_axis, X_AXIS)) {
                sprintf(acc_val,"%2.2f", MMA.x());
            }
            else if (!strcmp(selected_axis, Y_AXIS)) {
                sprintf(acc_val,"%2.2f", MMA.y());
            }
            else {
                sprintf(acc_val,"%2.2f", MMA.z());
            }
            if (sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, (uint8_t*)acc_val, strlen(acc_val), &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0) {
                pc.printf("Accelerometer data sending failed!\r\n");
            }
        }
    }
}

// GET and PUT allowed
static uint8_t acc_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    // GET, fetches accelerometer value for selected axis
    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET) {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
    
        coap_res_ptr->payload_len = 20;
        coap_res_ptr->payload_ptr = (uint8_t*)acc_val;
        
        if(received_coap_ptr->token_ptr)
        {
            if(obs_token_ptr)
            {
                free(obs_token_ptr);
                obs_token_ptr = 0;
            }
            obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
            if(obs_token_ptr)
            {
                memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
                obs_token_len = received_coap_ptr->token_len;
            }
        }
    
        if(received_coap_ptr->options_list_ptr->observe)
        {
            coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
            memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
            coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
            coap_res_ptr->options_list_ptr->observe_len = 1;
            obs_number++;
        }
    
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    
        coap_res_ptr->options_list_ptr->observe_ptr = 0;
    }
    // PUT, sets the selected axis from request (msg body 'xyz', 'xy', 'xz', 'yz', 'x', 'y' or 'z')
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT) {
        memcpy(received_cmd, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
        received_cmd[received_coap_ptr->payload_len] = '\0';
        sprintf(selected_axis, "%s", received_cmd);
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_accelerometer_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    static Thread exec_thread(exec_call_thread);
    nsdl_create_dynamic_resource(resource_ptr, sizeof(ACC_RES_ID)-1, (uint8_t*)ACC_RES_ID, 0, 0, 1, &acc_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));    
    return 0;
}