#ifndef MPU6050_H
#define MPU6050_H

#include "mbed.h"

#define MPU6050_DEFAULT_ADDRESS     0x68

// register
#define MPU6050_XA_OFFS_H_REG       0x06
#define MPU6050_YA_OFFS_H_REG       0x08
#define MPU6050_ZA_OFFS_H_REG       0x0A
#define MPU6050_XG_OFFS_USRH_REG    0x13
#define MPU6050_YG_OFFS_USRH_REG    0x15
#define MPU6050_ZG_OFFS_USRH_REG    0x17
#define MPU6050_CONFIG_REG          0x1A
#define MPU6050_GYRO_CONFIG_REG     0x1B
#define MPU6050_ACCEL_CONFIG_REG    0x1C
#define MPU6050_INT_PIN_CFG         0x37
#define MPU6050_ACCEL_XOUT_H_REG    0x3B
#define MPU6050_ACCEL_YOUT_H_REG    0x3D
#define MPU6050_ACCEL_ZOUT_H_REG    0x3F
#define MPU6050_TEMP_H_REG          0x41
#define MPU6050_GYRO_XOUT_H_REG     0x43
#define MPU6050_GYRO_YOUT_H_REG     0x45
#define MPU6050_GYRO_ZOUT_H_REG     0x47
#define MPU6050_PWR_MGMT_1_REG      0x6B
#define MPU6050_WHO_AM_I_REG        0x75

#define MPU6050_CLOCK_INTERNAL      0x00
#define MPU6050_CLOCK_PLL_XGYRO     0x01
#define MPU6050_CLOCK_PLL_YGYRO     0x02
#define MPU6050_CLOCK_PLL_ZGYRO     0x03
#define MPU6050_CLOCK_PLL_EXT32K    0x04
#define MPU6050_CLOCK_PLL_EXT19M    0x05
#define MPU6050_CLOCK_KEEP_RESET    0x07

#define MPU6050_GYRO_FS_250         0x00
#define MPU6050_GYRO_FS_500         0x01
#define MPU6050_GYRO_FS_1000        0x02
#define MPU6050_GYRO_FS_2000        0x03

#define MPU6050_ACCEL_FS_2          0x00
#define MPU6050_ACCEL_FS_4          0x01
#define MPU6050_ACCEL_FS_8          0x02
#define MPU6050_ACCEL_FS_16         0x03

class MPU6050 {
    public:
        MPU6050();
        MPU6050(uint8_t address);
        MPU6050(uint8_t address, PinName sda, PinName scl);
        
        void initialize();
        bool testConnection();
        uint8_t getDeviceID();
        
        void write(char address, char data);
        void writeWord(char address, int16_t data);
        char read(char address);
        void read(char address, char* data, int length);
        
        void setClockSource(uint8_t source);
        void setSleepEnable(bool enabled);
        void setFullScaleGyroRange(int8_t range);
        void setFullScaleAccelRange(int8_t range);
        
        void setXAccelOffset(int16_t offset);
        void setYAccelOffset(int16_t offset);
        void setZAccelOffset(int16_t offset);
        void setXGyroOffset(int16_t offset);
        void setYGyroOffset(int16_t offset);
        void setZGyroOffset(int16_t offset);
        
        void getMotion6(int16_t* ax, int16_t* ay, int16_t* az, int16_t* gx, int16_t* gy, int16_t* gz);
        
    private:
        uint8_t dev_addr;
        uint8_t buffer[14];
        I2C connection;
};

#endif