#include "mbed.h"
#include "NM500.h"
#include "Test.h"


void data_classify(void);
void NSR_Test(void);
void Connection_test(void);
void Memory_Test(void);

//connection 
int NSR_Conn_fail = 0;
int GCR_Conn_fail = 0;
int MINIF_Conn_fail = 0;
int MAXIF_Conn_fail = 0;
int NCR_Conn_fail = 0;
int INDEX_Conn_fail = 0;
int DIST_Conn_fail = 0;
int CAT_Conn_fail = 0;
int AIF_Conn_fail = 0;
int NID_Conn_fail = 0;
int Connection = 0;

//reset Test
int Reset_fail   = 0;

//memory test
int Memory_fail  = 0;

int id_fail     = 0;
int nsr_fail    = 0;

int CMN_Maxif   = 0;
int CMN_Nsr     = 0;
int CMN_Ncount  = 0;
int CMN_RC      = 0;
int CMN         = 0;

int Gcr1        = 0;
int Gcr2        = 0;
int Minif1      = 0;
int Minif2      = 0;
int Maxif1      = 0;
int Maxif2      = 0;
int Aif1        = 0;
int Aif2        = 0;
int Cat1        = 0;
int Cat2        = 0;

int Nid1        = 0;
int Nid2        = 0;
int Dist1       = 0;
int Dist2       = 0;

int Learn1      = 0;
int Learn2      = 0;

int Memory1     = 0;
int Memory2     = 0;

int NM1         = 0;
int NM2         = 0;

unsigned char array1[NEURONSIZE];
unsigned char array2[NEURONSIZE];


Serial pc(SERIAL_TX, SERIAL_RX);


int main() { 
    pc.baud(115200);

    pc.printf("\nPress any key to start\n");
    int data = pc.getc();
    
    pc.printf("\nNM500 Test Board V1.0 \n");
    
    //SPI Setting
    //time measure start
    
    SPI_Init();
    SD_Init();
    //reset Test
     
    RESET_Test();
    

    //NM500 Init
    if(begin() == 0){
        pc.printf("\nNM500 Init\n");
        pc.printf("\nTotal Neuron is %d ", countTotalNeurons());
    }
    else{
        error("IC Fail\n");
        
    } 
    
    //connection Test

    Connection_test();


    
    int m_test = Cell_Test();
    
    //Memory Test
    //중복 제거
    //Memory_Test();


    forget();

    //memory array init
    for(int i=0;i<NEURONSIZE;i=i+1){
        array1[i]=0x0a;
        array2[i]=0x05;         
    }
    NSR_Test();
      

    //NCOUNT Test
    int ncount_fail = read(NM_NCOUNT);
    
    if(ncount_fail != 0){
        CMN_Ncount = 1;
        error("NCOUNT Fail\n");
    }
  
    //minif test
    write(NM_MINIF,3);
//    int minif = read(NM_MINIF);
//    if(minif != 3)
//        CMN_Minif = 1;

    //maxif test
    write(NM_MAXIF,10000);  
    int maxif = read(NM_MAXIF);
    if(maxif != 10000)
        CMN_Maxif = 1;
    
    //GCR test
    write(NM_GCR,5);
//    int gcr = read(NM_GCR);
//    //pc.printf("gcr : %d",gcr);
//    if(gcr != 5)
//        CMN_Gcr = 1;
     
       
    //Neuron learn
    pc.printf("\nLearn Start\n");
    

    int daisy = data_learn();


    pc.printf("\nLearn Complete\n");


    
    //data save

    pc.printf("\nSave Start\n");
    
    int save = NeuronToSD();
    if(save == 0xFFFF || save == 0x7FFF)     //change
        save = MAXNEURONS;

    pc.printf("\nSave Complete\n");
 

    
    //forget
    forget();

    
    //restore
    pc.printf("\nRestore Start\n");
    
    int restore = SDToNeurons();
    
    if(restore == 0xFFFF || restore == 0x7FFF)     //change
        restore = MAXNEURONS;

    pc.printf("\nRestore Complete\n");


    
    setKNN();
    //classify

    pc.printf("\nClassify Start\n");

    data_classify();

    pc.printf("\nClassify Complete\n");

    
    
    pc.printf("\n****************Test Result****************\n");
    //nsr result
     if(CMN_Nsr ==1){
        pc.printf("NSR Register Fail\n");
        CMN++;
    }
        
    //NCOUNT Result
    if(CMN_Ncount ==1){
        pc.printf("NCOUNT Register Fail\n");
        CMN++;
    }
        
    //MAXIF Result
    if(CMN_Maxif ==1){
        pc.printf("MAXIF Register Fail\n");
        CMN++;
    }  
        
    //MINIF Result
    if(Minif1 ==1){
        pc.printf("#1 NM500 MINIF Register Fail\n");
        NM1++;
    }
    if(Minif2 ==1){
        pc.printf("#2 NM500 MINIF Register Fail\n");
        NM2++;
    }
    
    //learn result
    if(Learn1 == 1){
        pc.printf("#1 NM500 Learn Function Fail\n");
        NM1++; 
    }
    if(Learn2 == 1){
        pc.printf("#2 NM500 Learn Function Fail\n");
        NM2++; 
    }
    
    //Daisy Chain result
    if(daisy == 1){
        pc.printf("#1 NM500 Daisy Chain Fail\n");
        NM1++; 
    } 
      
    //GCR result
    if(Gcr1 == 1){
        pc.printf("#1 NM500 GCR Register Fail\n");
        NM1++;
    }
    if(Gcr2 == 1){
        pc.printf("#2 NM500 GCR Register Fail\n");
        NM2++;
    }
    //AIF result
    if(Aif1 == 1){
        pc.printf("#1 NM500 AIF Register Fail\n");
        NM1++;
    }
    if(Aif2 == 1){
        pc.printf("#2 NM500 AIF Register Fail\n");
        NM2++;
    }
    //Cat result
    if(Cat1 == 1){
        pc.printf("#1 NM500 CAT Register Fail\n");
        NM1++;
    }
    if(Cat2 == 1){
        pc.printf("#2 NM500 CAT Register Fail\n");
        NM2++;
    }
    if(save != MAXNEURONS){
        pc.printf("NM500 Learn Function Fail\n");
        CMN++;
    }
    if(restore != MAXNEURONS){
        pc.printf("NM500 Restore Function Fail\n");
        CMN++;
    }
    //NID result
    if(Nid1 == 1){
        pc.printf("#1 NM500 Nid Register Fail\n");
        NM1++;
    }
    if(Nid2 == 1){
        pc.printf("#2 NM500 Nid Register Fail\n");
        NM2++;
    }
    
    //Dist result
    if(Dist1 == 1){
        pc.printf("#1 NM500 Dist Register Fail\n");
        NM1++;
    }
    if(Dist2 == 1){
        pc.printf("#2 NM500 Dist Register Fail\n");
        NM2++;
    }
    if(Memory1 == 1 || m_test != 0){
        pc.printf("Memory1 : %d, m_test : %d",Memory1,m_test);
        pc.printf("#1 Memory Fail\n");
        NM1++;
    }
    if(Memory2 == 1){
        pc.printf("#2 NM500 Memory Fail\n");
        NM2++;
    }
    
    //final result
    if(Reset_fail == 1)
        pc.printf("Resest Test Fail\n");
    else
        pc.printf("Resest Test Pass\n");
        
    if(Connection == 1)
        pc.printf("Connection Test Fail\n");
    else
        pc.printf("Connection Test Pass\n");
    
    if(Memory_fail == 1 && m_test != 0)
        pc.printf("Memory Test Fail \n");
   else
        pc.printf("Memory Test Pass\n"); 
    if(NM1 !=0)
        pc.printf("#1 NM500 Function Test Fail\n");
    if(NM2 != 0)
        pc.printf("#2 NM500 Function Test Fail\n");   
    if(NM1 == 0 && NM2 == 0)
        pc.printf("NM500 Function Test PASS\n");
  

//    pc.printf("POWER SAVE ON\n");
//    write(NM_POWER_SAVE,0);

       
}




