#include "Mux4x2.h"


Mux4x2::Mux4x2(PinName s0, PinName s1)
    : _s0(s0), _s1(s1)
{
    _s0 = 0;
    _s1 = 0;
}

void  Mux4x2::setMux(int index)
{
    if(index > 3 || index < 0) 
    {
        // index out of range
        return;
    }    
    
    _s1 = ((index & 0b0010) >> 1);
    _s0 = ((index & 0b0001) >> 0);
}