#include "Mux16x1.h"

Mux16x1::Mux16x1(PinName sig, PinName s0, PinName s1, PinName s2, PinName s3)
    : _sig(sig), _s0(s0), _s1(s1), _s2(s2), _s3(s3)
{
    _s0 = 0;
    _s1 = 0;
    _s2 = 0;
    _s3 = 0;
}

void  Mux16x1::setAt(int index)
{
    _s3 = ((index & 0b1000) >> 3);
    _s2 = ((index & 0b0100) >> 2);
    _s1 = ((index & 0b0010) >> 1);
    _s0 = ((index & 0b0001) >> 0);
}

float Mux16x1::readAt(int index)
{
    this->setAt(index);
    return _sig.read();
}

float Mux16x1::read()
{
    return _sig.read();
}