#pragma once

#define M_PI 3.14159265358979323846264
#define JOYRANGE 20

#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))

Serial6050 mpu(PC_10, PC_11, PC_12);

RawSerial pc(USBTX,USBRX,115200);

DigitalOut relay_pin = GPIO[0];
DigitalOut valve_pin[3] = {DigitalOut(GPIO[1]),DigitalOut(GPIO[2]),DigitalOut(GPIO[3])};
DigitalIn fence_sw[4] = {DigitalIn(GPIO[4]),DigitalIn(GPIO[5]),DigitalIn(GPIO[6]),DigitalIn(GPIO[7])};
DigitalIn arc_stop[2] = {DigitalIn(GPIO[8]),DigitalIn(GPIO[9])}; //  Arc catch mech. Limit switch
InterruptIn emergency_stop = GPIO[10];
DigitalOut tapeLED = GPIO[11];


Thread StartSignal;
Thread ArcStart;
Thread ArcReturn;
Thread RoundlyRecovery;
Thread PanelThread;
Thread EncThread;

volatile int power[5] = {0,0,0,0,0};  //motor power
volatile int Motor[5] = {0,0,0,0,0};
volatile double pulse[2];
volatile double cm[2];
volatile char towelpoint = 0b00000000;
char data[3];
volatile char maincnt;
volatile char optioncnt;
volatile char moveflag[2] = {0,0};

float initialDeg = 0;
volatile int sign = 1;
volatile int doRecovery = 0;
volatile int catchFlag = 0;
volatile int readyFlag = 0;
volatile int endFlag = 0;

volatile int towelPlaceNum[4];

void note(int scale, int octave, int length);

enum field_ {
    RED,BLUE
};

enum mode_ {
    FINAL,TRIAL
};

enum move_ {
    RECOVERY,HANGOUT
};

enum fence_ {
    F,R,B,L
};

enum valve_ {
    T,C,E
};

enum axis_ {
    X,Y
};

enum name_ {
    nC,Cis,nD,Dis,nE,nF,Fis,nG,Gis,nA,Ais,nH
};

long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

int constrain(int x, int a, int b)
{
    if (x < a) return a;
    else if (x > b) return b;
    else return x;
}



void utilityInit()
{
    /*mpu.init();
    mpu.reset();*/
    for(int i = 0; i < 4; i++) fence_sw[i].mode(PullUp);
    for(int i = 0; i < 2; i++) arc_stop[i].mode(PullUp);
    emergency_stop.mode(PullDown);
    for(int i = 0; i < 10; i++) {
        LED[0] = LED[1] = LED[2] = LED[3] = LED[4] = !LED[0];
        wait(0.05);
    }
}


void dataConvert(char receive)
{
    //blue zone point
    if(SW[2].read() == TRIAL) {
        const char point[13] = {0,0b110010,0b001101,0b011010,0b100101,0b101100,0b010011,
                                    0b011001,0b100110,0b101010,0b010101,0b010110,0b101001};
        towelpoint = point[receive];
        
        if(SW[3].read() == RED) {
            towelpoint = ~towelpoint;
            for(int i = 6; i < 8; i++) bitClear(towelpoint,i);
        }
        
    } else if(SW[2].read() == FINAL) {
        const char point[13] = {0,0b11001100,0b00110011,0b00111100,0b11000011,0b11110000,0b00001111,
                                    0b01100110,0b10011001,0b10110100,0b01001011,0b11010010,0b00101101};
        towelpoint = point[receive];
        
        if(SW[3].read() == RED) {
            towelpoint = ~towelpoint;
        }
    }
    if(SW[1].read() == 1) bitClear(towelpoint,0);
}


void boardthread()
{
    for(int i = 0; i < 5; i++) LED[i] = 0;
    lcd.clear();

    lcd.printf(0,0,"Zone:");
    lcd.printf(0,1,"Mode:");

    while(1) {
        i2c.read(0x08 << 1,data,3);
        //pc,printf("towelNum : %u, shirtNum : %u, stFlag : %u\r\n",data[0],data[1],data[2]);

        dataConvert(data[0]);
        maincnt = data[0];
        optioncnt = data[1];
        moveflag[0] = bitRead(data[2],0);
        moveflag[1] = bitRead(data[2],1);

        SW[3].read() ? sign = -1 : 1;

        switch(SW[3].read()) {
            case RED :
                lcd.printf(5,0,"RED ");
                break;
            case BLUE :
                lcd.printf(5,0,"BLUE");
                break;
            default :
                break;
        }

        switch(SW[2].read()) {
            case FINAL :
                lcd.printf(5,1,"F:");
                break;
            case TRIAL :
                lcd.printf(5,1,"T:");
                break;
            default :
                break;
        }
        
        switch(SW[1].read()) {
            case 0 :
                lcd.printf(7,1,"Do-Rec-1");
                break;
            case 1 :
                lcd.printf(7,1,"No-Rec-1");
                break;
            default :
                break;
        }
        
        switch(SW[0].read()) {
            case 0 :
                lcd.printf(12,0,":-1");
                break;
            case 1 :
                lcd.printf(12,0,":-0");
                break;
            default :
                break;
        }

        for(int i = 0; i < 0xF; i++) {
            cerica.motor(i,power[i]);
            wait_us(10);
        }
        cerica.motor(1);
    }
}

void progStop()
{
    while(emergency_stop == 1) {
        for(int i = 0; i < 5; i++) power[i] = 0;
        tapeLED = 0;
    }
}


void note(int scale, int octave, int length)
{
    const float frequency[12] = {261.626,277.183,293.665,311.127,329.628,349.228,
                                    369.994,391.995,415.305,440.000,466.164,493.883};
                                    
    int up = octave * 2;
    up == 0 ? up = 1 : up = up;
    
    Buz.period(1 / (frequency[scale] * up));
    Buz = 0.5;
    wait(length);
    Buz = 0;
}
        


void BuzStart()
{
    Buz.period(1 / 2000.0);
    Buz = 0.5;
    wait(0.15);
    Buz.period(1 / 1000.0);
    wait(0.15);
    Buz = 0;
}


void BuzL()
{
    for(int i = 0; i < 15; i++) {
        Buz.period(1 / 880.0);
        Buz = 0.5;
        wait(0.02);
        Buz = 0;
        wait(0.02);
    }
    Buz = 0;
}

void BuzGo()
{
    Buz.period(1 / 523.252);
    Buz = 0.5;
    wait(0.2);
    Buz.period(1 / 783.99);
    wait(0.2);
    Buz.period(1 / 1046.504);
    wait(0.4);
    Buz = 0;
}
void BuzSub()
{
    Buz.period(1 / 698.456);
    Buz = 0.5;
    wait(0.2);
    Buz.period(1 / 880.000);
    wait(0.2);
    Buz.period(1 / 1046.504);
    wait(0.4);
    Buz = 0;
}

void EncRead()
{
    while(1) {
        for(int i = 0; i < 2; i++) {
            pulse[i] = Enc[i].getPulses();
            cm[i] = 6.0 * M_PI * pulse[i] / 720.0;
        }
    }
}

void openArc()
{
    pc.printf("\r\narc mechanism start!\r\n");
    valve_pin[C] = 1;
    while(arc_stop[1] == 1) {
        power[4] = -255;
        pc.printf("%d\r\n",power[4]);
    }
    power[4] = 0;
}


void closeArc()
{
    valve_pin[C] = 0;
    while(arc_stop[0] == 1) {
        power[4] = 255;
        pc.printf("%d\r\n",power[4]);
    }
    power[4] = 0;
}


void toVec(int x,int y,char correction)
{
    int mot[4];
    float bias = mpu.read();

    double Lx = x;
    double Ly = y;

    double Lrad = atan2(Lx,Ly);
    double Ldist = sqrt((double)(Lx * Lx + Ly * Ly));
    Ldist = constrain( Ldist, 0, 255 );

    mot[0] = Ldist * cos(Lrad - M_PI / 4);
    mot[1] = -Ldist * cos(Lrad + M_PI / 4);
    mot[2] = -Ldist * cos(Lrad - M_PI / 4);
    mot[3] = Ldist * cos(Lrad + M_PI / 4);

    for(int i = 0; i < 4; i++) {
        mot[i] -= mpu.read() * correction;
        power[i] = mot[i];
    }
}


void move(int spd, int dir)
{
    int mot[4];
    float rad = dir / 180.0 * M_PI;
    spd = constrain(spd, 0, 255);

    mot[0] = spd * cos(rad - M_PI / 4);
    mot[1] = -spd * cos(rad + M_PI / 4);
    mot[2] = -spd * cos(rad - M_PI / 4);
    mot[3] = spd * cos(rad + M_PI / 4);

    for(int i = 0; i < 4; i++) {
        mot[i] -= mpu.read() * 3;
        power[i] = mot[i];
    }
}


void turn(int deg)
{
    //float old = mpu.read();
    while(1) {
        //for(int i = 0; i < 4; i++) power[i] = (deg - old) - mpu.read();

        int dir;
        //if(abs(power[0]) < 30){
        deg - mpu.read() > 0 ? dir = 1 : dir = -1;
        for(int i = 0; i < 4; i++) power[i] = 40 * dir;
        //}

        if((abs(mpu.read()) >= abs(deg) - 1) || moveflag[1] == 1) break;
        for(int i = 0; i < 4; i++) pc.printf("%4d, ",power[i]);
        pc.printf("%f\r\n",mpu.read());

    }
    for(int i = 0; i < 4; i++) power[i] = 0;
    pc.printf("break\r\n");
}

void turn_slowly(int deg)
{
    //float old = mpu.read();
    while(1) {
        //for(int i = 0; i < 4; i++) power[i] = (deg - old) - mpu.read();

        int dir;
        //if(abs(power[0]) < 30){
        deg - mpu.read() > 0 ? dir = 1 : dir = -1;
        for(int i = 0; i < 4; i++) power[i] = 30 * dir;
        //}

        if((abs(mpu.read()) >= abs(deg) - 1) || moveflag[1] == 1) break;
        for(int i = 0; i < 4; i++) pc.printf("%4d, ",power[i]);
        pc.printf("%f\r\n",mpu.read());

    }
    for(int i = 0; i < 4; i++) power[i] = 0;
    pc.printf("break\r\n");
}


void correctDir()
{
    while(1) {
        /*for(int i = 0; i < 4; i++) power[i] = (initialDeg - mpu.read());

        int dir;
        if(abs(power[0]) < 40){
            initialDeg - mpu.read() > 0 ? dir = 1 : dir = -1;
            for(int i = 0;i < 4;i++) power[i] = 10 * dir;
        }

        if((mpu.read() == initialDeg)) break;*/
        int dir;
        initialDeg - mpu.read() > 0 ? dir = 1 : dir = -1;
        for(int i = 0; i < 4; i++) power[i] = 40 * dir;

        if(abs(mpu.read()) < 2) break;

        for(int i = 0; i < 4; i++) pc.printf("%4d, ",power[i]);
        pc.printf("%f\r\n",mpu.read());
    }
    for(int i = 0;i < 4;i++) power[i] = 0;
    pc.printf("break\r\n");
}


void catchThrow()
{
    while(1) {
        if(doRecovery == 1) {
            valve_pin[C] = 0;
            //pc.printf("valve_pin[C] = 0\r\n");
            wait(0.5);

            catchFlag = 1;

            //pc.printf("catchFlag = 1\r\n");
            while(arc_stop[0].read() == 1) {
                power[4] = 255;
                //pc.printf("%d, as0 : %d\r\n",power[4],arc_stop[0].read());
            }
            power[4] = 0;
            valve_pin[C] = 1;

            //pc.printf("valve_pin[C] = 1\r\n");
            wait(1);
            power[4] = -255;//,// pc.printf("arc back. wait...\r\n"), wait(0.5);
            power[4] = 0;
            wait(0.5);
            while(arc_stop[0].read() == 1) {
                power[4] = 255;
                //pc.printf("%d, as0 : %d\r\n",power[4],arc_stop[0].read());
            }
            power[4] = 0;
            wait(0.5);
            power[4] = -255, wait(0.5);
            power[4] = 0;
            wait(0.5);
            while(arc_stop[0].read() == 1) {
                power[4] = 255;
                //pc.printf("%d, as0 : %d\r\n",power[4],arc_stop[0].read());
            }
            power[4] = 0;

            while(arc_stop[1].read() == 1) {
                power[4] = -255;
                //pc.printf("%d, as1 : %d\r\n",power[4],arc_stop[1].read());
            }
            power[4] = 0;

            readyFlag = 1;

            while(endFlag == 0) {
                if(endFlag == 1) break;
            }
            endFlag = 0;
            readyFlag = 0;
            catchFlag = 0;
            doRecovery = 0;
            //pc.printf("two Flag & doRecovery = 0\r\n");
        }
    }
}