#include "mbed.h"
#include "board.h"
#include "Serial6050.h"
#include "utility.h"

//blue Zone ... SW[3] = OFF(1) : sign = -1
//red Zone ... SW[3] = ON(0) : sign = 1
//SW[3].read() ? sign = -1 : 1;

//qualifying ... SW[2] = OFF(1)
//final ... SW[2] = ON(0)

//y ... upward +
//x ... right -

//61.5, 15

void recoveryMainThread()
{
    int targetX = 0;
    int targetY = 0;
    int breakdist = 0;

    while(1) {
        
        pc.printf("%f\r\n",mpu.read());
        
        if(moveflag[0] == 1 && optioncnt == 0xD && maincnt != 0) {
            BuzStart();
            if(SW[3].read() == BLUE) ArcStart.start(openArc);
            
            mpu.reset();
            for(int i = 0; i < 2; i++) Enc[i].reset();
            pc.printf("recovery_main start!\r\n");
            for(int i = 0; i < 2; i++) Enc[i].reset();
            wait(0.5);

            BuzGo();
            pc.printf("go!!\r\n");
            if(SW[3].read() == BLUE) valve_pin[E] = 1;

            while(fence_sw[L].read() == 1) {
                toVec(-40,0,3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("Lsw : %d\r\n",fence_sw[L].read());
            }
            for(int i = 0; i < 2; i++) Enc[i].reset();
            //mpu.reset();

            targetX = 130;
            while(abs(cm[X]) < targetX) {
                toVec(120,cm[Y] * 2,3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("cmX : %lf, tgX : %d, ",cm[X],targetX);
                pc.printf("cmY : %lf\r\n",cm[Y]);
            }

            targetX = 430;
            SW[3].read() == BLUE ? targetY = 110 : targetY = 90;

            while(abs(cm[X]) < targetX) {
                float spd = targetX - abs(cm[X]);
                spd > 100 ? spd = 100 : spd;
                if(spd < 40) break;
                toVec(spd,(abs(cm[Y]) - targetY) * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("cmX : %lf, tgX : %d, ",cm[X],targetX);
                pc.printf("2 * cmY : %lf, tgY : %d, ",(abs(cm[Y]) - targetY) * sign,targetY);
                pc.printf("cmY : %lf\r\n",cm[Y]);
            }


            if(SW[3].read() == BLUE) {
                while(fence_sw[R].read() == 1) {
                    toVec(40,(targetY - abs(cm[Y])) * 2,3);
                    for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                    pc.printf("Rsw : %d, ",fence_sw[R].read());
                    pc.printf("cmY : %lf\r\n",cm[Y]);
                }
            } else if(SW[3].read() == RED) {
                while(fence_sw[R].read() == 1 || fence_sw[B].read() == 1) {
                    toVec(40 * fence_sw[R].read(),-40 * fence_sw[B].read(),3);
                    for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                    pc.printf("Rsw : %d, ",fence_sw[R].read());
                    pc.printf("Bsw : %d\r\n",fence_sw[B].read());
                }
                toVec(0,0,0);
                ArcStart.start(openArc);
                valve_pin[C] = 1;
                wait(0.8);
                Enc[Y].reset();
                toVec(-40,0,3);
                pc.printf("toVec(-40,0,3), 0.7sec;\r\n");
                wait(1.3);
                toVec(0,0,0),wait(0.5);

                while(abs(mpu.read()) < 38 && moveflag[0] == 0) {
                    power[0] = power[3] = 40;
                    pc.printf("%f, power[0,3]=30\r\n",mpu.read());
                }
                toVec(0,0,0);
            }


            toVec(0,0,0);
            Enc[Y].reset();


            valve_pin[C] = 0, wait(0.5);
            power[4] = 255,wait(2);
            power[4] = 0;

            if(SW[3].read() == RED) {
                while(abs(mpu.read()) > 2 && moveflag[0] == 0) {
                    power[0] = power[3] = -40;
                    pc.printf("%f, power[0,3]=-30\r\n",mpu.read());
                }
                toVec(0,0,0),wait(0.5);
                toVec(0,40,3);
                pc.printf("toVec(0,40,3), 1sec;\r\n");
                wait(1);
                toVec(0,0,0);
                Enc[Y].reset();
            }

            breakdist = 170;
            float spd = 70;
            //spd = abs(cm[X]) - 120;
            while(1) {
                spd = abs(cm[X]) - breakdist;
                if(spd < 2) break;
                spd > 70 ? spd = 70 : spd = spd;
                spd < 30 ? spd = 30 : spd = spd;
                toVec(-spd,0,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmX : %lf, ",cm[X]);
                pc.printf("cmY : %lf\r\n",cm[Y]);

            }
            wait(0.5);
            turn(-170 * sign);
            wait(0.2);

            Enc[X].reset();
            Enc[Y].reset();
            Timer t;
            t.start();
            while(fence_sw[R].read() == 1) {
                toVec(40,cm[Y] * 2,0);
                for(int j = 0; j < 4; j++) pc.printf("%d, ",power[j]);
                pc.printf("Press fsR, cmX : %d\r\n",cm[X]);
            }
            t.stop();
            toVec(0,0,0);

            float(taregtX) = abs(cm[X]);

            while(arc_stop[1] == 1) {
                power[4] = -255;
            }
            valve_pin[C] = 1;
            wait(0.5);

            Enc[X].reset();


            toVec(-40,cm[Y],0);
            wait(t.read());

            toVec(0,0,0);
            correctDir();
            toVec(0,0,0);

            targetX = 250;

            for(int i = 0; i < 2; i++) Enc[i].reset();
            wait(0.5);

            spd = 80;

            while(1) {
                spd = targetX - abs(cm[X]);
                if(spd < 2) break;
                spd > 80 ? spd = 80 : spd < 40 ? spd = 30 : spd = spd;
                toVec(spd,cm[Y],3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, cmX : %lf, tgX : %d\r\n",spd,cm[X],targetX);
            }
            toVec(0,0,0), wait(0.5);

            while(fence_sw[F].read() == 1 && fence_sw[B].read() == 1) {
                toVec(0,-40 * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("Fsw : %d, ",fence_sw[F].read());
                pc.printf("Bsw : %d\r\n",fence_sw[B].read());
            }

            toVec(0,-40 * sign,0), wait(0.5);
            toVec(0,0,0);

            toVec(0,0,0);
            Enc[X].reset();
            Enc[Y].reset();
            wait(0.5);

            const float towelDist_t[6] = {146/12, 146/4, 146 * 5 / 12, 146 * 7 / 12, 146 * 9 / 12, 146 * 11 / 12};
            const float towelDist_f[8] = {146/16, 146 * 3 / 16, 146 * 5 / 16, 146 * 7 / 16, 146 * 9 / 16, 146 * 11 / 16, 146 * 13 / 16, 146 * 15 / 16};
            const float throwPlaceDist_t[6] = {190, 200, 210, 220, 240, 250};
            const float throwPlaceDist_f[8] = {190, 200, 210, 210, 220, 230, 240, 260};
            const int tDeg_t[6] = {10 + 15, 16 + 15, 22 + 15, 28 + 15, 35 + 15, 42 + 15};
            const int tDeg_f[8] = {10 + 15, 14 + 15, 19 + 15, 23 + 15, 28 + 15, 32 + 15, 38 + 15, 43 + 15};

            int cnt = 0;

            for(int i = 0; i < 8; i++) {
                if(bitRead(towelpoint,i) == 1) {
                    towelPlaceNum[0 + cnt] = i;
                    cnt++;
                    pc.printf("TPNum : %c\r\n",towelPlaceNum[i]);
                } else {}
            }

            SW[0].read() == 0 ? cnt -= 1 : cnt = cnt;

            int Ydist;
            SW[2].read() == TRIAL ? Ydist = towelDist_t[towelPlaceNum[0]] : towelDist_f[towelPlaceNum[0]];
            int plusdist;
            SW[3].read() == BLUE ? plusdist = 140 : plusdist = 94;
            int targetY = Ydist + plusdist;

            Enc[X].reset();
            Enc[Y].reset();

            //ArcStart.start(openArc);

            spd = targetY - abs(cm[Y]);
            pc.printf("spd : %f, targetY : %d\r\n",spd,targetY);

            while(1) {
                spd = targetY - abs(cm[Y]);
                if(spd < 1) break;
                spd > 60 ? spd = 60 : spd = spd;
                spd < 40 ? spd = 30 : spd = spd;

                toVec(cm[X] * 2,spd * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmY : %lf, ",cm[Y]);
                pc.printf("tgY : %d\r\n",targetY);
            }

            toVec(0,0,0), wait(0.5);

            Enc[X].reset();
            Enc[Y].reset();
            Timer limit;
            
            for(int i = 0; i < cnt; i++) {
                limit.reset();
                limit.start();
                while(fence_sw[R].read() == 1 && limit.read() < 3) {
                    toVec(40,cm[Y],3);
                    for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                    pc.printf("Rsw : %d\r\n",fence_sw[R].read());
                }
                toVec(0,0,0);
                limit.stop();
                limit.reset();

                if(i != cnt - 1) {

                    doRecovery = 1;

                    while(catchFlag == 0) {
                        if(catchFlag == 1) break;
                    }

                    SW[2].read() == TRIAL ? targetX = throwPlaceDist_t[towelPlaceNum[i]] : targetX = throwPlaceDist_f[towelPlaceNum[i]];
                    Enc[X].reset(), wait(0.2);
                    spd = targetX - abs(cm[X]);
                    while(1) {
                        spd = targetX - abs(cm[X]);
                        if(spd < 1) break;
                        spd > 70 ? spd = 70 : spd = spd;
                        spd < 40 ? spd = 30 : spd = spd;

                        toVec(-spd,cm[Y] * 2,3);

                        for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                        pc.printf("tgX : %f, ",targetX);
                        pc.printf("spd : %f, ",spd);
                        pc.printf(" cmX : %lf\r\n",cm[X]);
                    }
                    toVec(0,0,0);
                    SW[2].read() == TRIAL ? turn(-tDeg_t[i] * sign) : turn(-tDeg_f[i] * sign);

                    while(readyFlag == 0) {
                        if(readyFlag == 1) break;
                    }

                    BuzL();
                    valve_pin[T] = 1, wait(1.5);
                    valve_pin[T] = 0, wait(0.5);
                    endFlag = 1;
                    correctDir(), toVec(0,0,0);
                    wait(1);

                    int breakdist = 60;
                    spd = abs(cm[X]) - breakdist;

                    while(1) {
                        spd = abs(cm[X]) - breakdist;
                        if(spd < 1) break;
                        spd > 80 ? spd = 80 : spd < 40 ? spd = 30 : spd = spd;
                        toVec(spd,cm[Y] * 2,3);
                        for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                        pc.printf("spd : %f, ",spd);
                        pc.printf(" cmX : %lf\r\n",cm[X]);
                    }
                    toVec(0,0,0), wait(0.5);
                    Enc[X].reset();
                    Enc[Y].reset();
                    wait(1);

                    SW[2].read() == TRIAL ? targetY = towelDist_t[towelPlaceNum[i + 1]] : targetY = towelDist_f[towelPlaceNum[i + 1]];
                    SW[2].read() == TRIAL ? targetY -= towelDist_t[towelPlaceNum[i]] : targetY = towelDist_f[towelPlaceNum[i]];

                    spd = targetY - abs(cm[Y]);
                    while(1) {
                        spd = targetY - abs(cm[Y]);
                        if(spd < 1) break;
                        toVec(-cm[X],40 * sign,3);
                        for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                        pc.printf("spd : %f, ",spd);
                        pc.printf("cmY : %lf\r\n",cm[Y]);
                    }
                    toVec(0,0,0),wait(0.5);
                    Enc[X].reset();
                    Enc[Y].reset();
                } else if(i == cnt - 1) {

                    valve_pin[C] = 0;

                    wait(0.5);
                    Enc[X].reset();
                    Enc[Y].reset();

                    SW[2].read() == TRIAL ? targetY = towelDist_t[towelPlaceNum[i]] : targetY = towelDist_f[towelPlaceNum[i]];
                    targetX = 450;

                    float spdX = targetX - abs(cm[X]);

                    while(1) {
                        spdX = targetX - abs(cm[X]);
                        if(spdX < 1) break;
                        spdX > 80 ? spdX = 80 : spdX < 30 ? spdX = 30 : spdX = spdX;

                        const int Kp = 1;

                        toVec(-spdX,((abs(cm[Y]) - targetY) * sign) * Kp,3);

                        for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                        pc.printf("Y : %f, ",float(((abs(cm[Y]) - (targetY + 10)) * sign) * Kp));
                        pc.printf(" cmY : %lf\r\n",cm[Y]);
                        pc.printf("spd : %f, ",spd);
                        pc.printf(" cmX : %lf\r\n",cm[X]);
                    }
                    toVec(0,0,0), wait(0.5);
                    turn(85 * sign);
                    toVec(0,0,0);
                    wait(0.5);
                    valve_pin[C] = 1, valve_pin[E] = 1;
                    wait(1), valve_pin[C] = 0;
                    ArcReturn.start(closeArc);
                    BuzStart();

                }
            }
        }
    }
}

void hangoutMainThread()
{
    while(1) {

        if(moveflag[0] == 1 && maincnt == 0xF) {
            BuzStart(), wait(0.5);
            BuzGo();

            mpu.reset();
            for(int i = 0; i < 2; i++) Enc[i].reset();

            int plusdist;
            SW[3].read() == BLUE ? plusdist = 175 : plusdist = 220;
            float Ydist = 17.5 * optioncnt;

            while(fence_sw[F].read() == 1 && fence_sw[B].read() == 1) {
                toVec(-cm[X],-40 * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("Fsw : %d, ",fence_sw[F].read());
                pc.printf("Bsw : %d\r\n",fence_sw[B].read());

            }
            toVec(0,0,0);
            for(int i = 0; i < 2; i++) Enc[i].reset();
            wait(0.2);

            float targetY = plusdist + Ydist;
            float spd = targetY - abs(cm[Y]);

            while(abs(cm[Y]) < targetY) {
                spd = targetY - abs(cm[Y]);
                spd > 70 ? spd = 70 : spd = spd;
                spd < 40 ? spd = 30 : spd = spd;

                toVec(-cm[X],spd * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmY : %lf, ",cm[Y]);
                pc.printf("tgY : %f\r\n",targetY);
            }
            toVec(0,0,0);
            wait(0.5);

            int targetX = 240;

            spd = targetX - abs(cm[X]);

            while(1) {
                spd = targetX - abs(cm[X]);
                spd > 120 ? spd = 120 : spd = spd;
                spd < 40 ? spd = 40 : spd = spd;
                toVec(-spd,cm[Y] - (targetY * -sign),3);

                if(abs(cm[X]) > targetX) break;

                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmX : %lf, ",cm[X]);
                pc.printf("tgX : %d\r\n",targetX);

            }

            toVec(0,0,0), wait(1);

            while(abs(cm[X]) > 1) {
                float spdX = abs(cm[X]);
                spdX > 100 ? spdX = 100 : spdX = spdX;
                if(spdX < 40) spdX = 30;
                toVec(spdX,cm[Y] - (targetY * -sign),3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spdX : %f, ",spdX);
                pc.printf("cmX : %lf\r\n",cm[X]);
            }
            toVec(0,0,0), wait(0.5);
            float spdY = abs(cm[Y]);
            spdY > 100 ? spdY = 100 : spdY = spdY;

            while(abs(cm[Y]) > 30) {
                float spdY = abs(cm[Y]);
                spdY > 80 ? spdY = 80 : spdY = spdY;
                if(spdY < 40) spdY = 30;
                toVec(-cm[X],-spdY * sign,3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spdY : %f, ",spdY);
                pc.printf("cmY : %lf\r\n",cm[Y]);
            }
            toVec(0,0,0);

            BuzStart();
        }

        if(moveflag[1] == 1 && maincnt == 0xF) {
            BuzStart(), wait(0.2);
            BuzSub();
            mpu.reset();
            for(int i = 0; i < 2; i++) Enc[i].reset();

            int plusdist;
            SW[3].read() == BLUE ? plusdist = 175 : plusdist = 220;
            float Ydist = 17.5 * optioncnt;

            while(fence_sw[F].read() == 1 && fence_sw[B].read() == 1) {
                toVec(-cm[X],-40 * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("Fsw : %d, ",fence_sw[F].read());
                pc.printf("Bsw : %d\r\n",fence_sw[B].read());

            }
            toVec(0,0,0);
            for(int i = 0; i < 2; i++) Enc[i].reset();
            wait(0.2);

            ArcStart.start(openArc);

            float targetY = plusdist + Ydist;
            float spd = targetY - abs(cm[Y]);

            while(abs(cm[Y]) < targetY) {
                spd = targetY - abs(cm[Y]);
                spd > 70 ? spd = 70 : spd = spd;
                spd < 40 ? spd = 30 : spd = spd;

                toVec(-cm[X],spd * sign,2);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmY : %lf, ",cm[Y]);
                pc.printf("tgY : %f\r\n",targetY);
            }
            toVec(0,0,0);
            wait(0.5);
            int targetX = 240;

            spd = targetX - abs(cm[X]);

            while(1) {
                spd = targetX - abs(cm[X]);
                spd > 120 ? spd = 120 : spd = spd;
                spd < 40 ? spd = 40 : spd = spd;
                toVec(-spd,cm[Y] - (targetY * -sign),3);
                if(abs(cm[X]) > targetX) break;

                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spd : %f, ",spd);
                pc.printf("cmX : %lf, ",cm[X]);
                pc.printf("tgX : %f\r\n",targetX);

            }
            toVec(0,0,0), wait(1);

            valve_pin[T] = 1, wait(2);
            valve_pin[T] = 0, wait(1);
            ArcReturn.start(closeArc);

            while(abs(cm[X]) > 1) {
                float spdX = abs(cm[X]);
                spdX > 100 ? spdX = 100 : spdX = spdX;
                if(spdX < 40) spdX = 30;
                toVec(spdX,cm[Y] - (targetY * -sign),3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spdX : %f, ",spdX);
                pc.printf("cmX : %lf\r\n",cm[X]);
            }
            toVec(0,0,0), wait(0.5);
            float spdY = abs(cm[Y]);
            spdY > 100 ? spdY = 100 : spdY = spdY;
            while(abs(cm[Y]) > 30) {
                float spdY = abs(cm[Y]);
                spdY > 80 ? spdY = 80 : spdY = spdY;
                if(spdY < 40) spdY = 30;
                toVec(-cm[X],-spdY * sign,3);
                for(int i = 0; i < 4; i++) pc.printf("%d, ",power[i]);
                pc.printf("spdY : %f, ",spdY);
                pc.printf("cmY : %lf\r\n",cm[Y]);
            }
            toVec(0,0,0);

            BuzStart();
        }
    }
}



void test()
{
    while(1) {
    }
}

// main() runs in its own thread in the OS
int main()
{
    //mpu.reset();
    pc.printf("\r\nHi! I'm Maika!\r\n");
    boardInit();
    pc.printf("\r\nboardInit OK!\r\n");
    utilityInit();
    pc.printf("\r\nutiliyInit OK!\r\n");

    RoundlyRecovery.start(catchThrow);

    emergency_stop.rise(progStop);
    PanelThread.start(boardthread);
    EncThread.start(EncRead);
    Thread R;
    R.start(recoveryMainThread);
    Thread H;
    H.start(hangoutMainThread);

    BuzStart();
    
    for (int i = 0; i < 5; i++) LED[i] = 1;

    while (1) {
        
        /*tapeLED = !emergency_stop.read();
        if(maincnt == 0xE && optioncnt == 0xE && moveflag[1] == 1) {
            BuzL();
            valve_pin[E] = 1;
        }*/
    }
}