#pragma once

#include "mbed.h"
#include "QEI.h"
enum WireSel {FEP01,TweLite};

class CERICA
{
private:
    DigitalOut wireSelect;
    I2C i2c;
    PwmOut buz;
    BusOut leds;
    BusIn sw;
    DigitalOut dReset;
    QEI xEnc;
    QEI yEnc;

    char ADDR;
    bool brake;
    bool isEnc;
    long map(long x, long in_min, long in_max, long out_min, long out_max);
    char configData;
    char Div;
    //int minSpd;
    int maxSpd;

public:
    CERICA(I2C *i2c_,WireSel WireSel_);

    // Board LED
    bool LED(int n_,bool l_);

    // Board SW
    bool SW(int n_)
    {
        return (~sw >> n_) & 0x1;
    }

    // Motor
    bool Send(bool available_ = 1);
    void Motor(char sendChannel,int verocity)
    {
        power[sendChannel] = verocity;
    }
    void maxRange(int maxSpd_)
    {
        maxSpd = maxSpd_;
    }
    void Set(bool isEnc_ = false,bool brake_ = false)
    {
        brake = brake_, isEnc = isEnc_;
    }


    // Speaker
    void Play(int scale_); // scale = 0 : C0
    void Stop()
    {
        buz = 0;
    }

    // Encoder
    int GetX()
    {
        return xEnc.getPulses();
    }
    int GetY()
    {
        return yEnc.getPulses();
    }
    void ResetX()
    {
        return xEnc.reset();
    }
    void ResetY()
    {
        return yEnc.reset();
    }

    //bool init(char toMD , bool rvs = false , bool omni = true, bool sound  = false , frequency freq = F256, int channel_ = 0);

    bool RawMotor(char sendChannel,int verocity);
    bool wait(int waitT);

    bool SystemReset(char sendChannel);
    bool ConfigReset(char sendChannel);
    bool DscOn(char sendChannel,bool mode);
    bool OutputFlip(char sendChannel,bool mode);
    bool DscPortOpen(char sendChannel,bool mode);
    bool SoundOn(char sendChannel,bool mode);
    bool SetDivider(char sendChannel,char pulse);
    /*void SetSpeedLimit(int min, int max)
    {
        minSpd = min;
        maxSpd = max;
    }*/
    int powerOut[16];
    int power[16];
};