#include "cerica2.h"

CERICA::CERICA(I2C *i2c_,WireSel WireSel_) :
    wireSelect(PC_4),
    i2c(PB_9,PB_8),
    buz(PA_0),
    leds(PA_15, PB_7, PC_13, PC_2, PC_3),
    sw(PC_0, PC_1, PB_0, PA_4),
    dReset(PC_12), // deviceReset pin
    xEnc(PC_6, PC_5, PC_8, 360),
    yEnc(PA_11, PB_12, PA_12, 360),
    brake(false),isEnc(false),
    maxSpd(240)
{
    dReset = 1;
    wireSelect = WireSel_;
    ADDR = 0x10 << 1;
    sw.mode(OpenDrain);
    xEnc.reset();
    yEnc.reset();
    wait_ms(200);
    dReset = 0;
}

long CERICA::map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// Motor
bool CERICA::Send(bool available_)
{
    bool isI2c = 1;
    for (int i = 0; i < 0xF; i++) {
        int vInt = abs(power[i]) * available_;
        if (vInt > 255) vInt = 255;
        unsigned char v = vInt;
        char direction;
        if (v > 0) {
            //if (v > 255) v = 255;
            v = map(v, 0, 255, 0, maxSpd);
            direction = power[i] < 0;
        } else {
            direction = (0b10 | !brake);
        }
        char send[3] = {(char)(0x80 | i), (char)((isEnc << 2) | direction),(char)(v >> 1)};
        
        wait_us(20);
        powerOut[i] = (power[i] < 0) ? v * -1 : v;
        isI2c = i2c.write(ADDR, send, 3);
    }
    return isI2c;
}

bool CERICA::RawMotor(char sendChannel,int verocity)
{
    char direction;
    if (verocity > 0) {
        direction = 0b00;
        if (verocity > 255) verocity = 255;
    } else if (verocity < 0) {
        direction = 0b01;
        if (verocity < -255) verocity = -255;
        verocity *= -1;
    } else direction = 0b10 | !brake;
    char send[3] = {(char)(0x80 | sendChannel), (char)((isEnc << 2) | direction), (char)verocity};
    return i2c.write(ADDR, send, 3);
}


// LED
bool CERICA::LED(int n_,bool l_)
{
    int mask = ~(1 << n_);
    leds = (leds & mask) | (l_ << n_);
    return (leds >> n_) & 0x1;
}

// Sound
void CERICA::Play(int scale_)
{
    double freq = 440 * pow(2.0,scale_ / 12.0);
    buz.period(1 / freq);
    buz = 0.5;
}



/*bool CERICA::init(char toMD,bool rvs , bool omni , bool sound , frequency freq , int channel_)
{
    char send[3];
    send[0] = 0x90 | channel;
    send[1] = omni << 4 | rvs << 2 | sound;
    send[2] = freq << 4 | channel_;
    channel = channel_;
    return i2c.write(ADDR, send, 3);
}*/
