#include "cerica2.h"

CERICA::CERICA(I2C *i2c_,WireSel WireSel_) : wireSelect(PC_4)
{
    i2c = i2c_;
    wireSelect = 1;//WireSel_;
    ADDR = 0x10 << 1;
    brake = isEnc = channel = false;
    configData = 0;
    Div = 0;
    maxSpd = 240;
    minSpd = 0;
    for (int i = 0 ; i < 16; i++)  {
        powerOut[i] = 0;
        power[i] = 0;
    }
}

void CERICA::mRange(int minSpd_,int maxSpd_) {
    minSpd = minSpd_;
    maxSpd = maxSpd_;
}

/*bool CERICA::init(char toMD,bool rvs , bool omni , bool sound , frequency freq , int channel_)
{
    char send[3];
    send[0] = 0x90 | channel;
    send[1] = omni << 4 | rvs << 2 | sound;
    send[2] = freq << 4 | channel_;
    channel = channel_;
    return i2c->write(ADDR, send, 3);
}*/

void CERICA::set(bool isEnc_,bool brake_,int channel_ )
{
    brake = brake_;
    isEnc = isEnc_;
    channel = channel_;

}

long CERICA::map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

bool CERICA::motor(bool available_)
{
    bool isI2c = 1;
    char send_[9];
    for (int i = 0; i < 16; i++) {
        char v = abs(power[i]) * available_;
        char direction;
        if (v > 0) {
            if (v > 255) v = 255;
            v = map(v, 0, 255, minSpd, maxSpd);
            direction = power[i] < 0;
        } else {
            direction = (0b10 | !brake);
        }
        char send[3] = {0x80 | i , (isEnc << 2) | direction ,v >> 1};
        //send_[i * 3] = 0x80 | i;
        //send_[i * 3 + 1] = (isEnc << 2) | direction;
        //send_[i * 3 + 2] = v >> 1;
        powerOut[i] = (power[i] < 0) ? v * -1 : v;
        isI2c = i2c->write(ADDR, send, 3);
        
        wait_us(20);
    }
    //isI2c = i2c->write(ADDR, send_, 3 * 3);
    return isI2c;
}

void CERICA::motor(char sendChannel,int verocity)
{
    power[sendChannel] = verocity;
}

bool CERICA::RawMotor(char sendChannel,int verocity)
{
    char direction;
    if (verocity > 0) {
        direction = 0b00;
        if (verocity > 255) verocity = 255;
    } else if (verocity < 0) {
        direction = 0b01;
        if (verocity < -255) verocity = -255;
        verocity *= -1;
    } else direction = 0b10 | !brake;
    char send[3] = {0x80 | sendChannel , (isEnc << 2) | direction, verocity};
    return i2c->write(ADDR, send, 3);
}