#include "vnh5019.h"
#include "mbed.h"

VNH5019::VNH5019(PinName _dirH,PinName _dirL,PinName _pwm):
    dirH(_dirH),dirL(_dirL), pwm(_pwm) {
    started = false;
    pwm.period(1/20000.0);
    dirL = 0;
    dirH = 0;
    pwm=0;
    braking=false;
}

int VNH5019::setFreq(float freq)
{
        if(freq <= 0)
            return 1;
        pwm.period(1/freq);
        return 0;
}
        
int VNH5019::setMotorSpeed(float speed)
{
    started = true;
    if(speed >=1.0)
        speed = 1.0;
    if(speed <= -1.0)
        speed = -1.0;
    if(fabs(speed) > 0.02){
        if(speed > 0){
            dirH = 0;
            dirL = 1;
        }else{
            dirH = 1;
            dirL = 0;
        }
        pwm = fabs(speed);
    }else{
        dirH = 0;
        dirL = 0;
        pwm = 0;
    }
    return 0;
}