#ifndef VNH5019_H
#define VNH5019_H

#include "mbed.h"
/**
* vnh5019 class
* class to drive vnh5019
*/
class VNH5019
{
public:
    /** creates VNH5019 instance
    *@param _dirH dirH pin
    *@param _dirL dirL pin
    *@param _pwm pwm pin
    */ 
    VNH5019(PinName _dirH,PinName _dirL,PinName _pwm);
    /** set drive Mode won't work after setMotorSpeed() is called
    */ 
    int setMotorSpeed(float speed);
    /** set pwm frequency
    *@param frequency needs to be bigger than 0
    */
    int setFreq(float freq);
    /** set this variable to 1 if you want to brake when the motorSpeed is set to 0
    */
    bool  braking;
private:
    bool started;
    DigitalOut dirH,dirL;
    PwmOut pwm;
};
#endif